package com.devplatform.admin.config;

import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.sys.service.SysSystemService;
import org.springframework.stereotype.Component;

import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
/**
 * 此注解相当于设置访问URL
 * @author Administrator
 */
@Component
@ServerEndpoint("/websocket/{shopId}")
public class WebSocket {

    public static SysSystemService sysSystemService;
    private static CopyOnWriteArraySet<WebSocket> webSockets = new CopyOnWriteArraySet<>();
    private static CopyOnWriteArraySet<WebSocket> webSocketPub = new CopyOnWriteArraySet<>();
    private static Map<String, Session> sessionPool = new HashMap<String, Session>();
    private Session session;

    @OnOpen
    public void onOpen(Session session, @PathParam(value = "shopId") String shopId) {
        this.session = session;
        if (Constants.STRING_1001.equals(shopId)) {
            // shopId=1001 代表是报警发送请求
            webSockets.add(this);
            sessionPool.put(shopId, session);
            System.out.println("【websocket1001消息】有新的连接\n\tsessionId：" + session.getId() + "\n\t总数为:" + webSockets.size());
        } else if (Constants.STRING_1002.equals(shopId)) {
            // shopId=1002 代表是接管发送请求
            webSocketPub.add(this);
            sessionPool.put(shopId, session);
            System.out.println("【websocket1002消息】有新的连接\n\tsessionId：" + session.getId() + "\n\t总数为:" + webSocketPub.size());
        }
    }

    @OnClose
    public void onClose() {
        webSockets.remove(this);
        webSocketPub.remove(this);
        System.out.println("【websocket消息】连接断开，总数为:" + webSockets.size());
    }

    @OnMessage
    public void onMessage(String message, @PathParam(value = "shopId") String shopId) {

    }

    /**
     * 此为广播消息
     * @param message
     */
    public void sendAllMessage(String message) {
        for (WebSocket webSocket : webSockets) {
            System.out.println("【websocket消息】广播消息:" + message);
            try {
                synchronized (webSocket.session) {
                    webSocket.session.getAsyncRemote().sendText(message);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 此为广播接管时的消息
     * @param message
     */
    public void sendPubAllMessage(String message) {
        System.out.println("message = " + message);
        for (WebSocket webSocket : webSocketPub) {
            System.out.println("【webSocketPub消息】广播消息:" + message);
            try {
                webSocket.session.getAsyncRemote().sendText("default_" + message);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 此为单点消息 (发送文本)
     * @param shopId
     * @param message
     */
    public void sendTextMessage(String shopId, String message) {
        Session session = sessionPool.get(shopId);
        if (session != null) {
            try {
                session.getBasicRemote().sendText(message);
                System.out.println("消息发送成功!");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 此为单点消息 (发送对象)
     * @param shopId
     * @param message
     */
    public void sendObjMessage(String shopId, Object message) {
        Session session = sessionPool.get(shopId);
        if (session != null) {
            try {
                session.getAsyncRemote().sendObject(message);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebSocket webSocket = (WebSocket) o;
        return Objects.equals(session, webSocket.session);
    }

    @Override
    public int hashCode() {
        return Objects.hash(session);
    }
}
