package com.devplatform.admin.modules.eq.bean;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author dxw
 */
@Data
@ApiModel(value="算法模块预警信息表",description="算法模块预警信息表")
@TableName("warn_info")
public class WarnInfo implements Serializable {
	private static final long serialVersionUID = 1L;

	/** 主键id */
	@ApiModelProperty(value="主键ID",name="id")
	@TableId
	private String id;
	/** 预警类型（1：数值范围错误，2：网络问题连接不上，3：空调机组滤网压差故障，4：空调机组故障，5：恢复） */
	@ApiModelProperty(value="预警类型",name="infoStatus")
	private Integer infoStatus;
	/** 资源点id */
	@ApiModelProperty(value="资源点id",name="resourceId")
	private String resourceId;
	/** 资源点名称 */
	@ApiModelProperty(value="资源点名称",name="resourceName")
	private String resourceName;
	/** 点位名称 */
	@ApiModelProperty(value="点位名称",name="pointName")
	private String pointName;
	/** 点位id */
	@ApiModelProperty(value="点位id",name="pointId")
	private String pointId;
	/** 预警信息 */
	@ApiModelProperty(value="预警信息",name="info")
	private String info;
	/** 创建时间 */
	@ApiModelProperty(value="创建时间",name="createTime")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createTime;
}
