package com.devplatform.admin.modules.eq.bean;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author dxw
 */
@Data
@ApiModel(value="资阳西站空调机组信息对象",description="机房空调信息对象")
@TableName("zy_jfktp_info")
public class ZyJfktpInfo implements Serializable {
	private static final long serialVersionUID = 1L;

	/** 主键id */
	@ApiModelProperty(value="主键ID",name="id")
	@TableId
	private String id;
	/** 资源点id */
	@ApiModelProperty(value="资源点id",name="resourceId")
	private String resourceId;
	/** 空调回风温度 */
	@ApiModelProperty(value="空调回风温度",name="windTem")
	private String windTem;

	/** 水阀反馈 */
	@ApiModelProperty(value="水阀反馈",name="waterFeedback")
	private String waterFeedback;

	/** 新风温度 */
	@ApiModelProperty(value="新风温度",name="newTem")
	private String newTem;

	/** 季节 */
	@ApiModelProperty(value="季节",name="season")
	private String season;

	/** 滤网压差 */
	@ApiModelProperty(value="滤网压差",name="filterPressure")
	private String filterPressure;

	/** 风机压差 */
	@ApiModelProperty(value="风机压差",name="fanPressure")
	private String fanPressure;

	/** 状态 */
	@ApiModelProperty(value="状态",name="status")
	private String status;

	/** 故障 */
	@ApiModelProperty(value="故障",name="failure")
	private String failure;

	/** 手自动 */
	@ApiModelProperty(value="手自动",name="automatic")
	private String automatic;

	/** 空调能耗 */
	@ApiModelProperty(value="空调能耗",name="energy")
	private String energy;

	/** 类型(1手动，2节能) */
	@ApiModelProperty(value="类型(1手动，2节能)",name="type")
	private Integer type;
	/** 站点表id */
	@ApiModelProperty(value="站点表id",name="stationId")
	private String stationId;
	/** 创建时间 */
	@ApiModelProperty(value="创建时间",name="createTime")
	private java.util.Date createTime;
}
