package com.devplatform.admin.modules.eq.controller;

import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.common.utils.DateUtils;
import com.devplatform.admin.modules.eq.bean.SwqxzInfoHour;
import com.devplatform.admin.modules.eq.service.AnalysisService;
import com.devplatform.admin.modules.eq.service.SnqxzInfoHourService;
import com.devplatform.admin.modules.eq.service.SwqxzInfoHourService;
import com.devplatform.admin.modules.sys.service.SysFaulalarmService;
import com.devplatform.common.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 数据分析
 * @author dxw
 */
@Api(tags={"数据分析接口"})
@RestController
@RequestMapping("/analysis")
public class AnalysisController extends AbstractController {
	@Autowired
	private SysFaulalarmService sysFaulalarmService;
	@Autowired
	private AnalysisService analysisService;
	@Autowired
	private SwqxzInfoHourService swqxzInfoHourService;
	@Autowired
	private SnqxzInfoHourService snqxzInfoHourService;

	/**
	 * 首页
	 * @return
	 */
	@ApiOperation(value="获取首页展示数据", notes="获取首页展示数据")
	@GetMapping("/getSyParam")
	public R getSyParam(){
		return R.ok().put("bean", analysisService.getSyParam());
	}

	/**
	 * 获取室外气象站数据
	 * @return
	 */
	@ApiOperation(value="获取室外气象站数据", notes="获取室外气象站数据")
	@GetMapping("/getSwqxzInfoTj")
	public R getSwqxzInfoTj(String startTime, String endTime) {
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		List<SwqxzInfoHour> list = swqxzInfoHourService.getList(startTime,endTime);
		//温度
		List<List<String>> temperatureList = new ArrayList<List<String>>();
		//湿度
		List<List<String>> humidityList = new ArrayList<List<String>>();
		//风速
		List<List<String>> windSpeedList = new ArrayList<List<String>>();
		//照度
		List<List<String>> illuminanceList = new ArrayList<List<String>>();
		//co2
		List<List<String>> carbonDioxideList = new ArrayList<List<String>>();
		//细粒度
		List<List<String>> fineParticlesList = new ArrayList<List<String>>();
		//辐射
		List<List<String>> radiationList = new ArrayList<List<String>>();
		List<List<String>> bjList = new ArrayList<List<String>>();

		for (int i = 0; i < list.size(); i++) {
			//温度详情
			List<String> temperatureListDetail = new ArrayList<String>();
			//湿度详情
			List<String> humidityListDetail = new ArrayList<String>();
			//风速详情
			List<String> windSpeedListDetail = new ArrayList<String>();
			//照度详情
			List<String> illuminanceListDetail = new ArrayList<String>();
			//co2详情
			List<String> carbonDioxideListDetail = new ArrayList<String>();
			//细粒度详情
			List<String> fineParticlesListDetail = new ArrayList<String>();
			//辐射详情
			List<String> radiationListDetail = new ArrayList<String>();

			String time = DateUtils.format(list.get(i).getCreateTime(),"yyyy-MM-dd HH:mm:ss");

			temperatureListDetail.add(time);
			temperatureListDetail.add(list.get(i).getTemperature());

			humidityListDetail.add(time);
			humidityListDetail.add(list.get(i).getHumidity());

			windSpeedListDetail.add(time);
			windSpeedListDetail.add(list.get(i).getWindSpeed());

			illuminanceListDetail.add(time);
			illuminanceListDetail.add(list.get(i).getIlluminance());

			carbonDioxideListDetail.add(time);
			carbonDioxideListDetail.add(list.get(i).getCarbonDioxide());

			fineParticlesListDetail.add(time);
			fineParticlesListDetail.add(list.get(i).getFineParticles());

			radiationListDetail.add(time);
			radiationListDetail.add(list.get(i).getRadiation());

			temperatureList.add(temperatureListDetail);
			humidityList.add(humidityListDetail);
			windSpeedList.add(windSpeedListDetail);
			illuminanceList.add(illuminanceListDetail);
			carbonDioxideList.add(carbonDioxideListDetail);
			fineParticlesList.add(fineParticlesListDetail);
			radiationList.add(radiationListDetail);
		}

		List<Map<String,Object>> alarmList = sysFaulalarmService.getCountByResourceType(Constants.ID_SWQXZ,startTime,endTime);

		if(alarmList != null && alarmList.size() > 0 ){
			for (int i = 0; i < alarmList.size(); i++) {
				List<String> bjListDetail = new ArrayList<String>();

				SimpleDateFormat sdfLongTime = new SimpleDateFormat("yyyyMMddHH");
				Date d = (Date) alarmList.get(i).get("start_time");
				try{
					String time = DateUtil.getPlusTime(sdfLongTime.parse(sdfLongTime.format(d)));
					bjListDetail.add(time);
				}catch (ParseException e){
					e.printStackTrace();
				}
				bjListDetail.add(alarmList.get(i).get("total").toString());
				bjList.add(bjListDetail);
			}
		}

		return R.ok().put("temperatureList", temperatureList)
				.put("humidityList", humidityList)
				.put("windSpeedList", windSpeedList)
				.put("illuminanceList", illuminanceList)
				.put("carbonDioxideList", carbonDioxideList)
				.put("fineParticlesList", fineParticlesList)
				.put("radiationList", radiationList)
				.put("bjList",bjList);
	}

	/**
	 * 获取室内气象数据
	 * @return
	 */
	@ApiOperation(value="获取室内气象数据", notes="获取室内气象数据")
	@GetMapping("/getSnqxzInfoTj")
	public R getSnqxzInfoTj(String resourceId,String startTime,String endTime,Integer region) {
		List<Map<String,Object>> list = new ArrayList<>();
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		if(StringUtils.isNotBlank(resourceId)){
			list = snqxzInfoHourService.getList(resourceId,startTime,endTime);
		}else{
			list = snqxzInfoHourService.getListFx(region,startTime,endTime);
		}
		List<List<String>> temperatureList = new ArrayList<List<String>>();
		List<List<String>> humidityList = new ArrayList<List<String>>();
		List<List<String>> carbonDioxideList = new ArrayList<List<String>>();
		List<List<String>> bjList = new ArrayList<List<String>>();

		for (int i = 0; i < list.size(); i++) {
			List<String> temperatureListDetail = new ArrayList<String>();
			List<String> humidityListDetail = new ArrayList<String>();
			List<String> carbonDioxideListDetail = new ArrayList<String>();

			String time = DateUtils.format((Date) list.get(i).get("create_time"),"yyyy-MM-dd HH:mm:ss");

			temperatureListDetail.add(time);
			temperatureListDetail.add(list.get(i).get("temperature").toString());

			humidityListDetail.add(time);
			humidityListDetail.add(list.get(i).get("humidity").toString());

			carbonDioxideListDetail.add(time);
			carbonDioxideListDetail.add(list.get(i).get("carbon_dioxide").toString());

			temperatureList.add(temperatureListDetail);
			humidityList.add(humidityListDetail);
			carbonDioxideList.add(carbonDioxideListDetail);
		}

		List<Map<String,Object>> alarmList = sysFaulalarmService.getCountByResourceType(Constants.ID_SNQXZ,startTime,endTime);

		if(alarmList != null && alarmList.size() > 0 ){
			for (int i = 0; i < alarmList.size(); i++) {
				List<String> bjListDetail = new ArrayList<String>();

				SimpleDateFormat sdfLongTime = new SimpleDateFormat("yyyyMMddHH");
				Date d = (Date) alarmList.get(i).get("start_time");
				try{
					String time = DateUtil.getPlusTime(sdfLongTime.parse(sdfLongTime.format(d)));
					bjListDetail.add(time);
				}catch (ParseException e){
					e.printStackTrace();
				}
				bjListDetail.add(alarmList.get(i).get("total").toString());
				bjList.add(bjListDetail);
			}
		}

		return R.ok().put("temperatureList", temperatureList)
				.put("humidityList", humidityList)
				.put("carbonDioxideList", carbonDioxideList)
				.put("bjList",bjList);
	}

	/**
	 * 获取用电数据-统计图表
	 * @return
	 */
	@ApiOperation(value="获取用电数据-统计图表", notes="获取用电数据-统计图表")
	@GetMapping("/getEnergyTb")
	public R getEnergyTb(String resourceId, String startTime, String endTime, String resourceType) {
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		List<List<String>> list = analysisService.getEnergyListTb(resourceId,startTime,endTime,resourceType);
		return R.ok().put("list", list);
	}

	/**
	 * 获取能耗数据分析
	 * @return
	 */
	@ApiOperation(value="获取能耗数据分析", notes="获取能耗数据分析")
	@GetMapping("/getEnergyFx")
	public R getEnergyFx(String startTime,String endTime, String resourceType) {
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		List<List<String>> list = analysisService.getEnergyListFx(startTime,endTime,resourceType);
		return R.ok().put("list", list);
	}
	/**
	 * 资阳西站获取能耗数据分析
	 *
	 * @return
	 */
	@ApiOperation(value="资阳西站获取能耗数据分析", notes="资阳西站获取能耗数据分析")
	@GetMapping("/getZyEnergyFx")
	public R getZyEnergyFx(String startTime,String endTime, String resourceType) {
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		List<List<String>> list = analysisService.getZyEnergyFx(startTime,endTime,resourceType);
		return R.ok().put("list", list);
	}

	/**
	 * 数据分析-能耗数据-导出
	 * @param response
	 * @param startTime
	 * @param endTime
	 * @param resourceType
	 */
	@GetMapping("/export/toExcelFx")
	public void excel(HttpServletResponse response, String startTime,String endTime, String resourceType){
		startTime = DateUtil.getStringOfFirstDay(startTime);
		endTime = DateUtil.getStringOfLastDay(endTime);
		analysisService.toExcel(response,startTime,endTime,resourceType);
	}

	/**
	 * 设备故障分析
	 * @param params
	 * @return
	 */
	@ApiOperation(value = "设备故障分析", notes = "设备故障分析")
	@ApiImplicitParam(
			name = "params",
			value = "查询参数",
			required = true,
			paramType = "query",
			dataType = "Map<String, Object>")
	@GetMapping("/getFaultAlarmList")
	public R getFaultAlarmList(@RequestParam Map<String, Object> params) {
		params.put("startTime",DateUtil.getStringOfFirstDay((String) params.get("startTime")));
		params.put("endTime",DateUtil.getStringOfLastDay((String) params.get("endTime")));
		List<Map<String, Object>> typeList = sysFaulalarmService.getListGroupByResourceType(params);
		List<Map<String, Object>> idList = sysFaulalarmService.getListGroupByResourceId(params);
		return R.ok().put("typeList", typeList).put("idList",idList);
	}

}
