package com.devplatform.admin.modules.eq.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.devplatform.admin.common.scheduling.SimpleJob;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.common.utils.TestClient;
import com.devplatform.admin.config.WebSocket;
import com.devplatform.admin.modules.eq.bean.TimedTask;
import com.devplatform.admin.modules.eq.service.EquipmentService;
import com.devplatform.admin.modules.eq.service.TimedTaskService;
import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.model.LiResourceModel;
import com.devplatform.admin.modules.liresource.service.LiResourceService;
import com.devplatform.admin.modules.liresource.service.LiStationService;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.admin.modules.sys.bean.SysSystemRunningTime;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.service.SysSystemParamsService;
import com.devplatform.admin.modules.sys.service.SysSystemRunningTimeService;
import com.devplatform.common.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.ToString;
import org.apache.commons.lang.StringUtils;
import org.quartz.*;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备控制
 *
 * @author dxw
 */
@ToString
@Api(tags = {"设备接口"})
@RestController
@RequestMapping("/equipment")
public class EquipmentController extends AbstractController {
    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
    private static String JOB_GROUP_NAME = "quartz_name";
    private static String TRIGGER_GROUP_NAME = "quartz_group";
    @Autowired
    private EquipmentService equipmentService;
    @Autowired
    private SysSystemParamsService sysSystemParamsService;
    @Autowired
    private SysSystemRunningTimeService sysSystemRunningTimeService;
    @Autowired
    private TimedTaskService timedTaskService;
    @Autowired
    private LiStationService liStationService;
    @Autowired
    private WebSocket webSocket;
    @Autowired
    private LiResourceService liResourceService;
    //节能大循环节能算法间隔分钟
    @Value("${bigTime}")
    private String bigTime;
    //节能小循环节能算法间隔分钟
    @Value("${smallTime}")
    private String smallTime;

    /**
     * 资阳西站获取首页数据接口
     *
     * @return
     */
    @ApiOperation(value = "资阳西站获取首页数据接口", notes = "资阳西站获取首页数据接口")
    @GetMapping("/getHome")
    public R getHome(String startTime,String endTime, String resourceType) {
        Map<String, Object> list2 = equipmentService.getList2(startTime,endTime,resourceType);
        return R.ok().put("bean", list2);
    }
    /**
     * 发送首页最新数据
     *
     * @return
     */
    @ApiOperation(value = "发送首页最新数据", notes = "发送首页最新数据")
    @PostMapping("/sendHomeInfo")
    public R sendHomeInfo(String startTime,String endTime, String resourceType) {
        Map<String, Object> list2 = equipmentService.getList2(startTime, endTime, resourceType);
        webSocket.sendAllMessage(JSONObject.toJSONString(list2));
        return R.ok();
    }
    /**
     * 获取每个设备最新的参数值
     *
     * @return
     */
    @ApiOperation(value = "获取每个设备最新的参数值", notes = "获取每个设备最新的参数值")
    @GetMapping("/getListParam")
    public R getListParam() {
        Map<String, Object> list = equipmentService.getList();
        return R.ok().put("bean", list);
    }

    /**
     * 发送每个设备最新的参数值
     *
     * @return
     */
    @ApiOperation(value = "发送每个设备最新的参数值", notes = "发送每个设备最新的参数值")
    @PostMapping("/sendParamsInfo")
    public R sendParamsInfo() {
        Map<String, Object> list = equipmentService.getList();
        webSocket.sendAllMessage(JSONObject.toJSONString(list));
        return R.ok();
    }

    /**
     * 切换人工/节能模式
     *
     * @return
     */
    @ApiOperation(value = "切换人工/节能模式", notes = "切换人工/节能模式")
    @GetMapping("/changeType")
    public R changeType(Integer type) throws InterruptedException {
        Date time = new Date();
        //关闭全局得供暖、机械通风、自然通风模式
        SysSystemParams sysSystemParams = new SysSystemParams();
        sysSystemParams.setId(Constants.STRING_1);
        sysSystemParams.setType(type);
        sysSystemParams.setUpdateTime(time);
        sysSystemParams.setSun(Constants.INT_2);
        sysSystemParams.setFan(Constants.INT_2);
        sysSystemParams.setNan(Constants.INT_2);
        sysSystemParamsService.update(sysSystemParams, new LambdaQueryWrapper<SysSystemParams>()
                .eq(SysSystemParams::getId, Constants.STRING_1));

        //修改全局系统运行得结束时间
        SysSystemRunningTime sysSystemRunningTime = sysSystemRunningTimeService.getOne(new LambdaQueryWrapper<SysSystemRunningTime>()
                .orderByDesc(SysSystemRunningTime::getUpdateTime).last("limit 1"));
        sysSystemRunningTime.setEndTime(time);
        sysSystemRunningTime.setUpdateTime(time);
        sysSystemRunningTimeService.update(sysSystemRunningTime, new LambdaQueryWrapper<SysSystemRunningTime>()
                .eq(SysSystemRunningTime::getId, sysSystemRunningTime.getId()));

        //新增全局系统运行时间为当前时间
        SysSystemRunningTime temp = new SysSystemRunningTime();
        temp.setStartTime(time);
        temp.setType(type);
        temp.setEndTime(time);
        temp.setUpdateTime(time);
        sysSystemRunningTimeService.save(temp);

        //人工
        if (type == Constants.INT_1) {
            //查询定时任务（状态为开启、业务类型为节能），并且关闭节能模式
            //关闭节能大循环定时任务
            TimedTask timedTaskJnBig = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_1).eq(TimedTask::getBusinessType, Constants.INT_3).eq(TimedTask::getBusinessSonType,Constants.INT_1));
            if (timedTaskJnBig != null) {
                this.timedTask(timedTaskJnBig.getId(), timedTaskJnBig.getStartTime(), timedTaskJnBig.getEndTime(), Constants.INT_2, Constants.INT_3, null, "",Constants.INT_1);
            }
            //关闭节能小循环定时任务
            TimedTask timedTaskJnSmall = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_1).eq(TimedTask::getBusinessType, Constants.INT_3).eq(TimedTask::getBusinessSonType,Constants.INT_2));
            if (timedTaskJnSmall != null) {
                this.timedTask(timedTaskJnSmall.getId(), timedTaskJnSmall.getStartTime(), timedTaskJnSmall.getEndTime(), Constants.INT_2, Constants.INT_3, null, "",Constants.INT_2);
            }
//            //查询人工定时任务
//            TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_2)
//                    .eq(TimedTask::getBusinessType, Constants.INT_1)
//                    .last("limit 1"));
//            if(timedTask != null){
//                //开启人工定时任务
//                this.timedTask(timedTask.getId(),timedTask.getStartTime() , timedTask.getEndTime(), Constants.INT_1, Constants.INT_1, null, "",Constants.INT_3);
//            }
        } else if (type == Constants.INT_2) {
            //如果切换成节能模式，则关闭人工模式的定时任务，打开节能模式定时任务
//            TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_1)
//                    .eq(TimedTask::getBusinessType, Constants.INT_1)
//                    .last("limit 1"));
//            //关闭人工模式的定时任务
//            if (timedTask != null) {
//                //候车大厅全局
//                this.timedTask(timedTask.getId(), timedTask.getStartTime(), timedTask.getEndTime(), Constants.INT_2, 1, null, "",Constants.INT_3);
//            }
            //查询关闭得节能大循环节能模式
            TimedTask timedTaskJnBig = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_2).eq(TimedTask::getBusinessType, Constants.INT_3).eq(TimedTask::getBusinessSonType, Constants.INT_1));
            if (timedTaskJnBig != null) {
                //打开节能大循环节能模式定时任务
                this.timedTask(timedTaskJnBig.getId(), DateUtil.convertDateToMinute(time), timedTaskJnBig.getEndTime(), Constants.INT_1, Constants.INT_3, null, "",Constants.INT_1);
            } else {
                this.timedTask("", DateUtil.convertDateToMinute(time), "", Constants.INT_1, Constants.INT_3, null, "",Constants.INT_1);
            }
            //查询关闭得节能小循环节能模式
            TimedTask timedTaskJnsmall = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus, Constants.INT_2).eq(TimedTask::getBusinessType, Constants.INT_3).eq(TimedTask::getBusinessSonType, Constants.INT_2));
            if (timedTaskJnsmall != null) {
                //打开节能小循环节能模式定时任务
                this.timedTask(timedTaskJnsmall.getId(), DateUtil.convertDateToMinute(time), timedTaskJnsmall.getEndTime(), Constants.INT_1, Constants.INT_3, null, "",Constants.INT_2);
            } else {
                this.timedTask("", DateUtil.convertDateToMinute(time), "", Constants.INT_1, Constants.INT_3, null, "",Constants.INT_2);
            }
            //获取当前月、日、小时
            Calendar calendar = Calendar.getInstance();
            Integer month = calendar.get(java.util.Calendar.MONTH) + 1; // 月份是从0开始的，所以加1
            if (month != 3 && month != 4) {
                //执行节能任务大循环算法
                energyTask();
                Thread.sleep(10000);
                //执行节能任务小循环算法
                energyTask2();
            }
        }
        //原来的数据返回
        //Map<String, Object> list = equipmentService.getList();
        Map<String, Object> list = equipmentService.getList2("","","");
        webSocket.sendAllMessage(JSONObject.toJSONString(list));
        return R.ok();
    }

    /**
     * @param jobName @Description 移除任务(使用默认的任务组名 ， 触发器名 ， 触发器组名)
     */
    public static void removeJob(String jobName) {
        TriggerKey triggerKey1 = TriggerKey.triggerKey(jobName + "-start", TRIGGER_GROUP_NAME);
        TriggerKey triggerKey2 = TriggerKey.triggerKey(jobName + "-end", TRIGGER_GROUP_NAME);
        JobKey jobKey1 = JobKey.jobKey(jobName + "-start", JOB_GROUP_NAME);
        JobKey jobKey2 = JobKey.jobKey(jobName + "-end", JOB_GROUP_NAME);
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            Trigger trigger1 = (Trigger) sched.getTrigger(triggerKey1);
            Trigger trigger2 = (Trigger) sched.getTrigger(triggerKey2);
            if (trigger1 == null && trigger2 == null) {
                return;
            }
            if (trigger1 != null) {
                // 停止触发器
                sched.pauseTrigger(triggerKey1);
                // 移除触发器
                sched.unscheduleJob(triggerKey1);
                // 删除任务
                sched.deleteJob(jobKey1);
                System.err.println("移除任务:" + jobName + "-start");
            }
            if (trigger2 != null) {
                // 停止触发器
                sched.pauseTrigger(triggerKey2);
                // 移除触发器
                sched.unscheduleJob(triggerKey2);
                // 删除任务
                sched.deleteJob(jobKey2);
                System.err.println("移除任务:" + jobName + "-end");
            }
        } catch (Exception ignored) {
            System.err.println("移除定时任务出错");
        }
    }

    @ApiOperation(value = "定时任务开启/关闭", notes = "定时任务开启")
    @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
    @PostMapping("/timedTask")
    public R timedTask(String taskId, String startTime, String endTime, Integer status, Integer businessType, Integer type, String isReboot,Integer businessSonType) {
        TimedTask timedTask = null;
        //如果重启是启动的定时任务，不用更新数据库
        if (StringUtils.isBlank(isReboot)) {
            SysUserEntity user = getUser();
            if (StringUtils.isBlank(taskId)) {
                timedTask = new TimedTask();
                timedTask.setStartTime(startTime);
                timedTask.setBusinessType(businessType);
                timedTask.setType(type);
                timedTask.setEndTime(endTime);
                timedTask.setCreateTime(new Date());
                timedTask.setCreateUserId(user.getUserId());
                timedTask.setStatus(status);
                timedTaskService.save(timedTask);
            } else {

                timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType, businessType)
                        .eq(type != null, TimedTask::getType, type).eq(businessSonType != null, TimedTask::getBusinessSonType, businessSonType).last("limit 1"));
                timedTask.setStartTime(startTime);
                timedTask.setBusinessType(businessType);
                timedTask.setType(type);
                timedTask.setEndTime(endTime);
                timedTask.setStatus(status);
                timedTask.setUpdateTime(new Date());
                timedTask.setUpdateUserId(user.getUserId());
                timedTaskService.update(timedTask, new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getId, taskId));
            }

            taskId = timedTask.getId();
        }

        //开启
        if (status == 1) {
            //设置定时任务
            R error = setTimeTask(taskId, businessType, type, startTime, endTime,businessSonType);
            if (error != null) {
                return error;
            }
        } else {
            //关闭定时任务
            removeJob(taskId);
        }
        return R.ok();
    }

    /**
     * 设置定时任务
     *
     * @param id
     * @param startTime
     * @param endTime
     * @return
     */
    private R setTimeTask(String id, Integer businessType, Integer type, String startTime, String endTime,Integer businessSonType) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetail job1 = null;
            Trigger trigger1 = null;
            JobDetail job2 = null;
            Trigger trigger2 = null;
            if (StringUtils.isNotBlank(startTime)) {
                JobDataMap resJobDataMap1 = new JobDataMap();
                //设备开启
                resJobDataMap1.put("status", Constants.INT_1);
                resJobDataMap1.put("businessType", businessType);
                resJobDataMap1.put("type", type);
                resJobDataMap1.put("businessSonType", businessSonType);
                job1 = JobBuilder.newJob(SimpleJob.class).withIdentity(id + "-start", JOB_GROUP_NAME).usingJobData(resJobDataMap1).build();

                String cron1 = "";
                if (businessType == Constants.INT_3) {
                    if(businessSonType == Constants.INT_1){
                        trigger1 = TriggerBuilder.newTrigger().withIdentity(id + "-start", TRIGGER_GROUP_NAME).startNow()
                                .withSchedule(SimpleScheduleBuilder.repeatMinutelyForever(Integer.valueOf(bigTime))).build();
                    }else {
                        trigger1 = TriggerBuilder.newTrigger().withIdentity(id + "-start", TRIGGER_GROUP_NAME).startNow()
                                .withSchedule(SimpleScheduleBuilder.repeatMinutelyForever(Integer.valueOf(smallTime))).build();
                    }
                } else {
                    cron1 = createCron(startTime);
                    trigger1 = TriggerBuilder.newTrigger().withIdentity(id + "-start", TRIGGER_GROUP_NAME).startAt(new Date())
                            .withSchedule(CronScheduleBuilder.cronSchedule(cron1).withMisfireHandlingInstructionDoNothing()).build();
                }
            }
            if (StringUtils.isNotBlank(endTime)) {
                JobDataMap resJobDataMap2 = new JobDataMap();
                //设备关闭
                resJobDataMap2.put("status", Constants.INT_2);
                resJobDataMap2.put("businessType", businessType);
                resJobDataMap2.put("type", type);

                job2 = JobBuilder.newJob(SimpleJob.class).withIdentity(id + "-end", JOB_GROUP_NAME).usingJobData(resJobDataMap2).build();

                String cron2 = "";
                if (businessType == Constants.INT_3) {
                    int time = Integer.valueOf(endTime) + 30;
                    int time2 = time < 60 ? time : (time - 60);
                    if (Integer.valueOf(endTime).intValue() > time2) {
                        cron2 = createCron2(String.valueOf(time2), endTime);
                    } else {
                        cron2 = createCron2(endTime, String.valueOf(time2));
                    }
                } else {
                    cron2 = createCron(endTime);
                }
                trigger2 = TriggerBuilder.newTrigger().withIdentity(id + "-end", TRIGGER_GROUP_NAME).startAt(new Date())
                        .withSchedule(CronScheduleBuilder.cronSchedule(cron2).withMisfireHandlingInstructionDoNothing()).build();
            }


            if (job1 != null && trigger1 != null) {
                // 交给scheduler去调度
                sched.scheduleJob(job1, trigger1);
            }

            if (job2 != null && trigger2 != null) {
                sched.scheduleJob(job2, trigger2);
            }
            // 启动
            if (!sched.isShutdown()) {
                sched.start();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.err.println("设置定时任务1：" + id + "\n\t运行时间：" + sdf.format(trigger1.getNextFireTime()));
//			System.err.println("设置定时任务2：" + id + "\n\t下次运行时间：" + sdf.format(trigger2.getNextFireTime()));
        } catch (SchedulerException e) {
            e.printStackTrace();
            return R.error("时间设置有误！");
        }
        return null;
    }

    /**
     * 生成cron表达
     *
     * @param time 时间
     * @return cron
     */
    public String createCron(String time) {
        String[] strs = time.split(":");
        StringBuilder sb = new StringBuilder()
                .append(0).append(" ")
                .append(strs[1]).append(" ")
                .append(strs[0]).append(" * * ?");
        return sb.toString();
    }

    /**
     * 生成cron表达
     *
     * @param time 时间
     * @return cron
     */
    public String createCron2(String time, String time2) {
        //0 26,29,33 * * * ?
        //0 45,45,* * * * ?
        StringBuilder sb = new StringBuilder()
                .append(0).append(" ")
                .append(time).append(",").append(time2)
                .append(" * * * ?");
//		System.out.println(sb.toString());
        return sb.toString();
    }

    /**
     * 获取电动门帘的定时任务数据
     *
     * @return
     */
    @ApiOperation(value = "获取电动门帘的定时任务数据", notes = "获取电动门帘的定时任务数据")
    @GetMapping("/getAllDdml")
    public R getAllDdml() {
        List<TimedTask> timedTasks = timedTaskService.list(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType, Constants.INT_2));
        return R.ok().put("list", timedTasks);
    }

    /**
     * 候车大厅头上所有显示数据
     *
     * @return
     */
    @ApiOperation(value = "候车大厅头上所有显示数据", notes = "候车大厅头上所有显示数据")
    @GetMapping("/getAllHcdt")
    public R getAllHcdt() {
        SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);
        return R.ok().put("sysSystemParams", sysSystemParams);
    }

    @ApiOperation(value = "切换模式", notes = "切换模式")
    @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
    @PostMapping("/checkModel")
    public R checkModel(Integer type, Integer status) {
        // 控制资源点
        checkModelOnOrOff(type, status);

        SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);
        if (type == Constants.INT_1) {
            sysSystemParams.setSun(status);
            sysSystemParams.setFan(Constants.INT_2);
            sysSystemParams.setNan(Constants.INT_2);
        } else if (type == Constants.INT_2) {
            sysSystemParams.setSun(Constants.INT_2);
            sysSystemParams.setFan(status);
            sysSystemParams.setNan(Constants.INT_2);
        } else if (type == Constants.INT_3) {
            sysSystemParams.setSun(Constants.INT_2);
            sysSystemParams.setFan(Constants.INT_2);
            sysSystemParams.setNan(status);
        }
        sysSystemParamsService.update(sysSystemParams, new LambdaQueryWrapper<SysSystemParams>()
                .eq(SysSystemParams::getId, sysSystemParams.getId()));

        Map<String, Object> list = equipmentService.getList();
        webSocket.sendAllMessage(JSONObject.toJSONString(list));

        return R.ok();
    }


    /**
     * 查询定时温控里面的数据
     *
     * @return
     */
    @ApiOperation(value = "查询定时温控里面的数据", notes = "查询定时温控里面的数据")
    @GetMapping("/getAllDswk")
    public R getAllDswk() {
        TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType, Constants.INT_1).last("limit 1"));
        return R.ok().put("timedTask", timedTask);
    }

    @ApiOperation(value = "温度设定", notes = "温度设定")
    @PostMapping("/changeTemperature")
    public R changeTemperature(String temperature) {
        TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType, Constants.INT_1).last("limit 1"));
        timedTask.setTemperature(temperature);
        timedTaskService.update(timedTask, new LambdaQueryWrapper<TimedTask>()
                .eq(TimedTask::getId, timedTask.getId()));
        return R.ok();
    }

    /**
     * @param model
     * @return Map<String, String>
     * @Title: 设备开关
     */
    @PostMapping("/onOrOff")
    public Map<String, Object> doorOnOff(@RequestBody LiResourceModel model) {
//		String postUrl = getUrl(model.getStationId());
        return onOrOff(model);
    }

    /**
     * 执行节能任务大循环
     */
    private Map<String, Object> energyTask() {
//		String postUrl = "http://192.168.0.222:8089/command/energyTask";
        String postUrl = "http://localhost:8089/command/energyTask";
        Map<String, String> postParam = new HashMap<String, String>(10);
        Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
        Map<String, Object> map = null;
        if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
            map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
        }
        return map;
    }
    /**
     * 执行节能任务小循环
     */
    private Map<String, Object> energyTask2() {
//		String postUrl = "http://192.168.0.222:8089/command/energyTask";
        String postUrl = "http://localhost:8089/command/energyTask2";
        Map<String, String> postParam = new HashMap<String, String>(10);
        Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
        Map<String, Object> map = null;
        if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
            map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
        }
        return map;
    }

    /**
     * 根据选择人工模式，来控制资源点启停
     *
     * @param type   1=供暖模式，2=机械通风，3=自然通风
     * @param status 1=开启，2=关闭
     */
    private Map<String, Object> checkModelOnOrOff(Integer type, Integer status) {
//		String postUrl = "http://192.168.0.222:8089/command/operationType";
        String postUrl = "http://localhost:8089/command/operationType";
        Map<String, String> postParam = new HashMap<String, String>(10);
        postParam.put("params", status == 1 ? "1" : "0");
        postParam.put("rgType", type.toString());
        postParam.put("userId", getUserId());
        postParam.put("userName", getUser().getName());

        Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
        Map<String, Object> map = null;
        if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
            map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
        }
        return map;
    }

    private Map<String, Object> onOrOff(LiResourceModel model) {
//		String postUrl = "http://192.168.0.222:8089/command/operation";
        String postUrl = "http://localhost:8089/command/operation";
        Map<String, String> postParam = new HashMap<String, String>(10);
        postParam.put("liResourceId", model.getId());
        postParam.put("params", (model.getActionType() == Constants.INT_5 || model.getActionType() == Constants.INT_6 || model.getActionType() == Constants.INT_7
                || model.getActionType() == Constants.INT_8 || model.getActionType() == Constants.INT_9) ? model.getParams() : model.getStatus().toString());
        postParam.put("paramsName", model.getActionName());
        postParam.put("actionType", model.getActionType().toString());
        postParam.put("userId", getUserId());
        postParam.put("userName", getUser().getName());

        Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
        Map<String, Object> map = null;
        if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
            map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
        }
        return map;

    }

    private String getUrl(String stationId) {
        LiStation liStation = liStationService.getById(stationId);
        return liStation.getByx1();
    }


}
