package com.devplatform.admin.modules.eq.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.modules.eq.bean.SwqxzInfoHour;
import com.devplatform.admin.modules.eq.model.SwqxzInfoHourModel;
import com.devplatform.admin.modules.eq.service.KanBanService;
import com.devplatform.admin.modules.eq.service.SwqxzInfoHourService;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 数据看板
 * @author dxw
 */
@Api(tags={"数据看板接口"})
@RestController
@RequestMapping("/kanban")
public class KanBanController extends AbstractController {
    @Autowired
    private SwqxzInfoHourService swqxzInfoHourService;

    @Autowired
    private KanBanService kanBanService;

    /**
     * 获取室外气象站数据
     * @return
     */
    @ApiOperation(value="获取室外气象站数据", notes="获取室外气象站数据")
    @GetMapping("/getSwqxzInfo")
    public R getSwqxzInfo() {
        SwqxzInfoHourModel model = new SwqxzInfoHourModel();
        if(StringUtil.isEmpty(model.getSort())){
            model.setSort("create_time");
        }
        List<SwqxzInfoHour> list = swqxzInfoHourService.queryPageList(model);
        return R.ok().put("list", getMyPage(list,model));
    }

    /**
     * 查询历史数据
     * @param params
     * @return
     */
    @ApiOperation(value = "查询历史数据", notes = "查询历史数据")
    @ApiImplicitParam(
            name = "params",
            value = "查询参数",
            required = true,
            paramType = "query",
            dataType = "Map<String, Object>")
    @GetMapping("/getListByTypeAndId")
    public R getListByTypeAndId(@RequestParam Map<String, Object> params) {
        params.put("startTime", DateUtil.getStringOfFirstDay((String) params.get("startTime")));
        params.put("endTime",DateUtil.getStringOfLastDay((String) params.get("endTime")));
        Page<Map<String,Object>> page = kanBanService.getListByTypeAndId(params);
        return R.ok().put("page",page);
    }

    /**
     * 数据看板-历史数据-导出
     * @param response
     * @param params
     */
    @GetMapping("/export/toExcel")
    public void excel(HttpServletResponse response,@RequestParam Map<String, Object> params){
        params.put("startTime", DateUtil.getStringOfFirstDay((String) params.get("startTime")));
        params.put("endTime",DateUtil.getStringOfLastDay((String) params.get("endTime")));
        kanBanService.toExcel(response,params);
    }
}
