package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.DlswjInfoHourModel;
import com.devplatform.admin.modules.eq.bean.DlswjInfoHour;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * DlswjInfoHour Mapper
 * 用于多联室外机信息-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface DlswjInfoHourDao extends MyBaseMapper<DlswjInfoHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(DlswjInfoHourModel model);

    /**
     * 查询多联室外机信息-时分页数据
     * @param model
     * @return
     */
    List<DlswjInfoHour> queryPageList(DlswjInfoHourModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<ExcelInfo> queryList(@Param("params") Map<String, Object> params);
}
