package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.DlxfsnjInfoModel;
import com.devplatform.admin.modules.eq.bean.DlxfsnjInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * DlxfsnjInfo Mapper
 * 用于多联新风处理机室内机信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface DlxfsnjInfoDao extends MyBaseMapper<DlxfsnjInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(DlxfsnjInfoModel model);

    /**
     * 查询多联新风处理机室内机信息分页数据
     * @param model
     * @return
     */
    List<DlxfsnjInfo> queryPageList(DlxfsnjInfoModel model);

    List<Map<String, Object>> getList();
}
