package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.FlrbInfoModel;
import com.devplatform.admin.modules.eq.bean.FlrbInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * FlrbInfo Mapper
 * 用于风冷热泵机组信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface FlrbInfoDao extends MyBaseMapper<FlrbInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(FlrbInfoModel model);

    /**
     * 查询风冷热泵机组信息分页数据
     * @param model
     * @return
     */
    List<FlrbInfo> queryPageList(FlrbInfoModel model);

    List<Map<String, Object>> getList();
}
