package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.FlrbInfoDayModel;
import com.devplatform.admin.modules.eq.bean.FlrbInfoDay;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * FlrbInfoDay Mapper
 * 用于风冷热泵机组信息-天的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface FlrbInfoDayDao extends MyBaseMapper<FlrbInfoDay> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(FlrbInfoDayModel model);

    /**
     * 查询风冷热泵机组信息-天分页数据
     * @param model
     * @return
     */
    List<FlrbInfoDay> queryPageList(FlrbInfoDayModel model);

    /**
     * 查询风冷热泵机组信息-天分页数据
     * @param params
     * @return
     */
    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<ExcelInfo> queryList(@Param("params") Map<String, Object> params);
}
