package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.FlrbInfoYearModel;
import com.devplatform.admin.modules.eq.bean.FlrbInfoYear;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;

/**
 * FlrbInfoYear Mapper
 * 用于风冷热泵机组信息-年的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface FlrbInfoYearDao extends MyBaseMapper<FlrbInfoYear> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(FlrbInfoYearModel model);

    /**
     * 查询风冷热泵机组信息-年分页数据
     * @param model
     * @return
     */
    List<FlrbInfoYear> queryPageList(FlrbInfoYearModel model);
}
