package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.JfktpInfoDayModel;
import com.devplatform.admin.modules.eq.bean.JfktpInfoDay;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * JfktpInfoDay Mapper
 * 用于机房空调(220V)信息-天的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface JfktpInfoDayDao extends MyBaseMapper<JfktpInfoDay> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(JfktpInfoDayModel model);

    /**
     * 查询机房空调(220V)信息-天分页数据
     * @param model
     * @return
     */
    List<JfktpInfoDay> queryPageList(JfktpInfoDayModel model);

    /**
     * 查询机房空调(220V)信息-天分页数据
     * @param params
     * @return
     */
    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<ExcelInfo> queryList(@Param("params") Map<String, Object> params);
}
