package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.JfktpInfoMonthModel;
import com.devplatform.admin.modules.eq.bean.JfktpInfoMonth;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * JfktpInfoMonth Mapper
 * 用于机房空调(220V)信息-月的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface JfktpInfoMonthDao extends MyBaseMapper<JfktpInfoMonth> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(JfktpInfoMonthModel model);

    /**
     * 查询机房空调(220V)信息-月分页数据
     * @param model
     * @return
     */
    List<JfktpInfoMonth> queryPageList(JfktpInfoMonthModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<ExcelInfo> queryList(@Param("params") Map<String, Object> params);
}
