package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.PfjInfoModel;
import com.devplatform.admin.modules.eq.bean.PfjInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * PfjInfo Mapper
 * 用于排风机信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface PfjInfoDao extends MyBaseMapper<PfjInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(PfjInfoModel model);

    /**
     * 查询排风机信息分页数据
     * @param model
     * @return
     */
    List<PfjInfo> queryPageList(PfjInfoModel model);

    List<Map<String, Object>> getList();
}
