package com.devplatform.admin.modules.eq.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import com.devplatform.admin.modules.eq.bean.SbInfoDay;
import com.devplatform.admin.modules.eq.model.SbInfoDayModel;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * PfjInfoDay Mapper
 * 用于排风机信息-天的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SbInfoDayDao extends MyBaseMapper<SbInfoDay> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SbInfoDayModel model);

    /**
     * 查询排风机信息-天分页数据
     * @param model
     * @return
     */
    List<SbInfoDay> queryPageList(SbInfoDayModel model);

    /**
     * 查询排风机信息-天分页数据
     * @param page
     * @param params
     * @return
     */
    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
            @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<ExcelInfo> queryList(@Param("params") Map<String, Object> params);
}
