package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SljfgInfoHourModel;
import com.devplatform.admin.modules.eq.bean.SljfgInfoHour;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * SljfgInfoHour Mapper
 * 用于室内机风柜信息-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SljfgInfoHourDao extends MyBaseMapper<SljfgInfoHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SljfgInfoHourModel model);

    /**
     * 查询室内机风柜信息-时分页数据
     * @param model
     * @return
     */
    List<SljfgInfoHour> queryPageList(SljfgInfoHourModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
