package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SnqxzInfoModel;
import com.devplatform.admin.modules.eq.bean.SnqxzInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SnqxzInfo Mapper
 * 用于室内气象站信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SnqxzInfoDao extends MyBaseMapper<SnqxzInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SnqxzInfoModel model);

    /**
     * 查询室内气象站信息分页数据
     * @param model
     * @return
     */
    List<SnqxzInfo> queryPageList(SnqxzInfoModel model);

    List<Map<String, Object>> getList();

    List<Map<String, Object>> getList2(String time);
}
