package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SwqxzInfoModel;
import com.devplatform.admin.modules.eq.bean.SwqxzInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SwqxzInfo Mapper
 * 用于室外气象站信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SwqxzInfoDao extends MyBaseMapper<SwqxzInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SwqxzInfoModel model);

    /**
     * 查询室外气象站信息分页数据
     * @param model
     * @return
     */
    List<SwqxzInfo> queryPageList(SwqxzInfoModel model);

    List<Map<String, Object>> getList();

    List<Map<String, Object>> getList2();
}
