package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SwqxzInfoHourModel;
import com.devplatform.admin.modules.eq.bean.SwqxzInfoHour;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * SwqxzInfoHour Mapper
 * 用于室外气象站信息-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SwqxzInfoHourDao extends MyBaseMapper<SwqxzInfoHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SwqxzInfoHourModel model);

    /**
     * 查询室外气象站信息-时分页数据
     * @param model
     * @return
     */
    List<SwqxzInfoHour> queryPageList(SwqxzInfoHourModel model);

    List<SwqxzInfoHour> getList(@Param("startTime")String startTime,@Param("endTime")String endTime);


    /**
     * 查询室外气象站信息-时分页数据
     * @param page
     * @param params
     * @return
     */
    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<SwqxzInfoHour> queryList(@Param("params") Map<String, Object> params);
}
