package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.TimedTaskModel;
import com.devplatform.admin.modules.eq.bean.TimedTask;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;

/**
 * TimedTask Mapper
 * 用于定时任务的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface TimedTaskDao extends MyBaseMapper<TimedTask> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(TimedTaskModel model);

    /**
     * 查询定时任务分页数据
     * @param model
     * @return
     */
    List<TimedTask> queryPageList(TimedTaskModel model);
}
