package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.TotalDayModel;
import com.devplatform.admin.modules.eq.bean.TotalDay;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * TotalDay Mapper
 * 用于当月能耗-天的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface TotalDayDao extends MyBaseMapper<TotalDay> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(TotalDayModel model);

    /**
     * 查询当月能耗-天分页数据
     * @param model
     * @return
     */
    List<TotalDay> queryPageList(TotalDayModel model);

    List<Map<String,Object>> queryList(@Param("startTime")String startTime,@Param("endTime")String endTime);

    Map<String, Object> totalDay(@Param("time")String time, @Param("type")Integer type);
}
