package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.common.utils.DateUtils;
import com.devplatform.admin.common.utils.ExportExcelFx;
import com.devplatform.admin.modules.eq.service.*;
import com.devplatform.admin.modules.liresource.bean.LiResource;
import com.devplatform.admin.modules.liresource.service.LiResourceService;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.admin.modules.sys.service.SysResourceRunningTimeTjService;
import com.devplatform.admin.modules.sys.service.SysSystemParamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 设备的service接口实现类
 *
 * @author dxw
 */
@Service("analysisService")
public class AnalysisServiceImpl implements AnalysisService {
    @Autowired
    private SysSystemParamsService sysSystemParamsService;
    @Autowired
    private TotalDayService totalDayService;
    @Autowired
    private TotalHourService totalHourService;
    @Autowired
    private TotalMonthService totalMonthService;

    @Autowired
    private FlrbInfoService flrbInfoService;
    @Autowired
    private JfktpInfoService jfktpInfoService;
    @Autowired
    private PfjInfoService pfjInfoService;
    @Autowired
    private DlswjInfoService dlswjInfoService;
    @Autowired
    private SljfgInfoService sljfgInfoService;
    @Autowired
    private LiResourceService liResourceService;
    @Autowired
    private SbInfoService sbInfoService;
    @Autowired
    private SysResourceRunningTimeTjService sysResourceRunningTimeTjService;
    @Autowired
    private KqcljInfoService kqcljInfoService;

    @Override
    public Map<String, Object> getSyParam() {
        Map<String, Object> map = new HashMap<>();
        try {
            SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);
            int count = liResourceService.count(new LambdaQueryWrapper<LiResource>()
                    .eq(LiResource::getStatus, Constants.INT_4)
                    .eq(LiResource::getDeleted, Constants.INT_0));

            Integer dayTime = Integer.valueOf(sysSystemParams.getSystemRunningTime()) / (24 * 60 * 60);
            Integer hourTime = Integer.valueOf(sysSystemParams.getSystemRunningTime()) % (24 * 60 * 60) / (60 * 60);
            List<Integer> timeList = new ArrayList<>();
            timeList.add(dayTime);
            timeList.add(hourTime);

            //人工/节能模式
            map.put("type", sysSystemParams.getType());
            //系统运行时间
            map.put("systemRunningTime", timeList);
            //报警总数
            map.put("faultAlarm", count);
            //供暖模式
            map.put("sun", sysSystemParams.getSun());
            //机械通风模式
            map.put("fan", sysSystemParams.getFan());
            //自然通风模式
            map.put("nan", sysSystemParams.getNan());

            Integer t = 0;
            if (sysSystemParams.getSun() == Constants.INT_1) {
                t = 1;
            } else if (sysSystemParams.getFan() == Constants.INT_1) {
                t = 2;
            } else if (sysSystemParams.getNan() == Constants.INT_1) {
                t = 3;
            }
            //当前模式
            map.put("currentModel", t);

            //能耗
            Map<String, Object> energy = new HashMap<>();

            SimpleDateFormat sdfLongTime = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdfLongTime2 = new SimpleDateFormat("yyyyMM");
            Date now = new Date();
            String time = sdfLongTime.format(now);
            String time2 = sdfLongTime2.format(now);

            Map<String, Object> dayMap = totalDayService.totalDay(time, Constants.INT_1);
            Map<String, Object> dayMap2 = totalDayService.totalDay(time, Constants.INT_2);
            Map<String, Object> monthMap = totalMonthService.totalMonth(time2, Constants.INT_1);
            Map<String, Object> monthMap2 = totalMonthService.totalMonth(time2, Constants.INT_2);

            Map<String, Object> dayTotal = sysResourceRunningTimeTjService.totalDay(time);
            Map<String, Object> monthTotal = sysResourceRunningTimeTjService.totalMonth(time2);

            String sdEnergyDay = Constants.STRING_0;
            String jnEnergyDay = Constants.STRING_0;
            String sdEnergyMonth = Constants.STRING_0;
            String jnEnergyMonth = Constants.STRING_0;
            String totalEnergyDay = Constants.STRING_0;
            String totalEnergyMonth = Constants.STRING_0;
            if (dayMap != null && dayMap.size() >= 0) {
                if (dayMap.containsKey("electric_energy")) {
                    sdEnergyDay = dayMap.get("electric_energy").toString();
                }
            }
            if (dayMap2 != null && dayMap2.size() >= 0) {
                if (dayMap2.containsKey("electric_energy")) {
                    jnEnergyDay = dayMap2.get("electric_energy").toString();
                }
            }
            if (monthMap != null && monthMap.size() >= 0) {
                if (monthMap.containsKey("electric_energy")) {
                    sdEnergyMonth = monthMap.get("electric_energy").toString();
                }
            }
            if (monthMap2 != null && monthMap2.size() >= 0) {
                if (monthMap2.containsKey("electric_energy")) {
                    jnEnergyMonth = monthMap2.get("electric_energy").toString();
                }
            }

            if (dayTotal != null && dayTotal.size() >= 0) {
                if (dayTotal.containsKey("electric_energy")) {
                    totalEnergyDay = dayTotal.get("electric_energy").toString();
                }
            }

            if (monthTotal != null && monthTotal.size() >= 0) {
                if (monthTotal.containsKey("electric_energy")) {
                    totalEnergyMonth = monthTotal.get("electric_energy").toString();
                }
            }

            //当天
            //手动运行时间-天
            Integer sdHour = Integer.valueOf(sysSystemParams.getSdSystemRunningTimeDay()) / (60 * 60);
            Integer jnHour = Integer.valueOf(sysSystemParams.getJnSystemRunningTimeDay()) / (60 * 60);
            energy.put("sdSystemRunningTimeDay", sdHour);
            //节能运行时间-天
            energy.put("jnSystemRunningTimeDay", jnHour);
            energy.put("sdEnergyDay", sdEnergyDay);
            energy.put("jnEnergyDay", jnEnergyDay);
            energy.put("totalEnergyDay", totalEnergyDay);
            //当月
            //手动运行时间-月
            Integer sdHourM = Integer.valueOf(sysSystemParams.getSdSystemRunningTimeMonth()) / (60 * 60);
            Integer jnHourM = Integer.valueOf(sysSystemParams.getJnSystemRunningTimeMonth()) / (60 * 60);
            energy.put("sdSystemRunningTimeMonth", sdHourM);
            //节能运行时间-月
            energy.put("jnSystemRunningTimeMonth", jnHourM);
            energy.put("sdEnergyMonth", sdEnergyMonth);
            energy.put("jnEnergyMonth", jnEnergyMonth);
            energy.put("totalEnergyMonth", totalEnergyMonth);
            map.put("energy", energy);

            //能耗统计
            List<List<String>> list = new ArrayList<List<String>>();
            //当天
            List<Map<String, Object>> listHour = totalHourService.queryList(DateUtil.getStringOfFirstDay(DateUtil.getNowFormateDate()),
                    DateUtil.getStringOfLastDay(DateUtil.getNowFormateDate()));
            for (int i = 0; i < listHour.size(); i++) {
                List<String> listDetail = new ArrayList<String>();
                listDetail.add(DateUtils.format((Date) listHour.get(i).get("create_time"), "yyyy-MM-dd HH:mm:ss"));
                listDetail.add(listHour.get(i).get("electric_energy").toString());
                list.add(listDetail);
            }

            List<List<String>> listMonth = new ArrayList<List<String>>();
            //当月
            List<Map<String, Object>> listDay = totalDayService.queryList(DateUtil.getStringOfFirstDay(DateUtil.getStringOfFirstDayInMonth()),
                    DateUtil.getStringOfLastDay(DateUtil.getStringOfLastDayInMonth()));
            for (int i = 0; i < listDay.size(); i++) {
                List<String> listDetail = new ArrayList<String>();
                listDetail.add(DateUtils.format((Date) listDay.get(i).get("create_time"), "yyyy-MM-dd HH:mm:ss"));
                listDetail.add(listDay.get(i).get("electric_energy").toString());
                listMonth.add(listDetail);
            }

            map.put("energyList", list);
            map.put("energyListMonth", listMonth);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public List<List<String>> getEnergyListTb(String resourceId, String startTime, String endTime, String resourceType) {
        Page<Map<String, Object>> page = new Page<>();
        Map<String, Object> params = new HashMap<>(16);
        params.put("resourceId", resourceId);
        params.put("startTime", DateUtil.getStringOfFirstDay(startTime));
        params.put("endTime", DateUtil.getStringOfLastDay(endTime));
        Page<Map<String, Object>> pageTask = new Page<Map<String, Object>>(Constants.INT_1, Constants.INT_99);
        if (Constants.ID_PFJ.equals(resourceType)) {
            page = pfjInfoService.queryPageListByParam(pageTask, params);
        } else if (Constants.ID_JFKTP.equals(resourceType)) {
            page = jfktpInfoService.queryPageListByParam(pageTask, params);
        } else if (Constants.ID_JLM.equals(resourceType)) {

        } else if (Constants.ID_FLRBJZ.equals(resourceType)) {
            page = flrbInfoService.queryPageListByParam(pageTask, params);
        } else if (Constants.ID_SLJFG.equals(resourceType)) {

        } else if (Constants.ID_SB.equals(resourceType)) {
            page = sbInfoService.queryPageListByParam(pageTask, params);
        } else if (Constants.ID_SLSWJ.equals(resourceType)) {
            page = dlswjInfoService.queryPageListByParam(pageTask, params);
        } else if (Constants.ID_SLJFG.equals(resourceType)) {
            page = sljfgInfoService.queryPageListByParam(pageTask, params);
        }

        List<List<String>> listTj = new ArrayList<List<String>>();
        for (int i = 0; i < page.getRecords().size(); i++) {
            List<String> listDetail = new ArrayList<String>();
            listDetail.add(DateUtils.format((Date) page.getRecords().get(i).get("create_time"), "yyyy-MM-dd HH:mm:ss"));
            listDetail.add(page.getRecords().get(i).get("electric_energy").toString());
            listTj.add(listDetail);
        }
        return listTj;
    }

    @Override
    public List<List<String>> getEnergyListFx(String startTime, String endTime, String resourceType) {
        List<Map<String, Object>> list = new ArrayList<>();
        if (Constants.STRING_1.equals(resourceType)) {
            int type = DateUtil.checkTimeToType(startTime, endTime);
            if (type == Constants.INT_1) {
                list = totalHourService.queryList(startTime, endTime);
            } else if (type == Constants.INT_2 || type == Constants.INT_3) {
                list = totalDayService.queryList(startTime, endTime);
            } else if (type == Constants.INT_4) {
                list = totalMonthService.queryList(startTime, endTime);
            }
        } else if (Constants.ID_PFJ.equals(resourceType)) {
            list = pfjInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ID_JFKTP.equals(resourceType)) {
            list = jfktpInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ID_JLM.equals(resourceType)) {

        } else if (Constants.ID_SB.equals(resourceType)) {
            list = sbInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ID_FLRBJZ.equals(resourceType)) {
            list = flrbInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ID_SLJFG.equals(resourceType)) {
            list = sljfgInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ID_SLSWJ.equals(resourceType)) {
            list = dlswjInfoService.queryListByParam(startTime, endTime);
        }

        List<List<String>> listTj = new ArrayList<List<String>>();
        for (int i = 0; i < list.size(); i++) {
            List<String> listDetail = new ArrayList<String>();
            listDetail.add(DateUtils.format((Date) list.get(i).get("create_time"), "yyyy-MM-dd HH:mm:ss"));
            listDetail.add(list.get(i).get("electric_energy").toString());
            listTj.add(listDetail);
        }
        return listTj;
    }

    @Override
    public void toExcel(HttpServletResponse response, String startTime, String endTime, String resourceType) {
        OutputStream out = null;
        try {
            List<Map<String, Object>> list = new ArrayList<>();
            String title = "";
            if (Constants.STRING_1.equals(resourceType)) {
                title = "全部";
                int type = DateUtil.checkTimeToType(startTime, endTime);
                if (type == Constants.INT_1) {
                    list = totalHourService.queryList(startTime, endTime);
                } else if (type == Constants.INT_2 || type == Constants.INT_3) {
                    list = totalDayService.queryList(startTime, endTime);
                } else if (type == Constants.INT_4) {
                    list = totalMonthService.queryList(startTime, endTime);
                }
            } else if (Constants.ID_PFJ.equals(resourceType)) {
                title = "排风机";
                list = pfjInfoService.queryListByParam(startTime, endTime);
            } else if (Constants.ID_JFKTP.equals(resourceType)) {
                title = "空调";
                list = jfktpInfoService.queryListByParam(startTime, endTime);
            } else if (Constants.ID_SB.equals(resourceType)) {
                title = "水泵";
                list = sbInfoService.queryListByParam(startTime, endTime);
            } else if (Constants.ID_FLRBJZ.equals(resourceType)) {
                title = "风冷热泵机组";
                list = flrbInfoService.queryListByParam(startTime, endTime);
            } else if (Constants.ID_SLSWJ.equals(resourceType)) {
                title = "多联新风室外机";
                list = dlswjInfoService.queryListByParam(startTime, endTime);
            }

            String fileName = "energy.xlsx";
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            out = response.getOutputStream();

            Map<String, Object> map = new HashMap<>();
            map.put("title", title);
            List<String> strList = new ArrayList<>();
            strList.add("序号");
            strList.add("用电量");
            strList.add("时间");
            map.put("titles", strList);

            map.put("list", list);
            ExportExcelFx ee = new ExportExcelFx(map);
            ee.export(out);
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    /**
     * 资阳西站获取能耗数据分析
     *
     * @param startTime
     * @param endTime
     * @param resourceType
     * @return
     */
    @Override
    public List<List<String>> getZyEnergyFx(String startTime, String endTime, String resourceType) {
        List<Map<String, Object>> list = new ArrayList<>();
        if (Constants.ZY_QB.equals(resourceType)) {
            list = totalHourService.queryList(startTime, endTime);
        }
        //资阳西站空调机组能耗/小时
        if (Constants.ZY_KTJZ.equals(resourceType)) {
            list = jfktpInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ZY_FLRB.equals(resourceType)) {
            //资阳西站风冷热泵机组能耗/小时
            list = flrbInfoService.queryListByParam(startTime, endTime);
        } else if (Constants.ZY_KQCLJ.equals(resourceType)) {
            //资阳西站空气处理机机组能耗/小时
            list = kqcljInfoService.queryListByParam(startTime, endTime);
        }
        List<List<String>> listTj = new ArrayList<List<String>>();
        for (int i = 0; i < list.size(); i++) {
            for (int j = i+1; j < list.size(); j++) {
                List<String> listDetail = new ArrayList<String>();
                //获取第一个时间的总能耗
                String energyOne = list.get(i).get("electric_energy").toString();
                //获取第二个时间的总能耗
                String energyTwo = list.get(j).get("electric_energy").toString();
                //获取第一个时间
                String oneTime = list.get(i).get("create_time").toString();
                //获取第二个时间
                String twoTime = list.get(j).get("create_time").toString();
                listDetail.add(oneTime + "-" + twoTime);
                listDetail.add(new BigDecimal(energyTwo).subtract(new BigDecimal(energyOne)).toString());
                listTj.add(listDetail);
                break;
            }
        }
        return listTj;
    }
}
