package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.eq.bean.ZyFlrbInfo;
import com.devplatform.admin.modules.eq.bean.ZyJfktpInfo;
import com.devplatform.admin.modules.eq.service.*;
import com.devplatform.admin.modules.liresource.bean.LiResource;
import com.devplatform.admin.modules.liresource.service.LiResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 设备的service接口实现类
 *
 * @author dxw
 */
@Service("equipmentService")
public class EquipmentServiceImpl implements EquipmentService {
    @Autowired
    private DlsnjInfoService dlsnjInfoService;
    @Autowired
    private DlswjInfoService dlswjInfoService;
    @Autowired
    private FlrbInfoService flrbInfoService;
    @Autowired
    private JfktpInfoService jfktpInfoService;
    @Autowired
    private PfjInfoService pfjInfoService;
    @Autowired
    private SbInfoService sbInfoService;
    @Autowired
    private SljfgInfoService sljfgInfoService;
    @Autowired
    private SnqxzInfoService snqxzInfoService;
    @Autowired
    private SwqxzInfoService swqxzInfoService;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private SnqxzInfoHourService snqxzInfoHourService;
    @Autowired
    private DlxfsnjInfoService dlxfsnjInfoService;
    @Autowired
    private LiResourceService liResourceService;
    @Autowired
    private ZyFlrbInfoService zyFlrbInfoService;
    @Autowired
    private ZyJfktpInfoService zyJfktpInfoService;
    @Autowired
    private KqcljInfoService kqcljInfoService;

    @Override
    public Map<String, Object> getList() {
        Map<String, Object> map = new HashMap<String, Object>(32);
        //室内气象站
        List<Map<String, Object>> snqxzList = snqxzInfoService.getList();
        //室外气象站
        List<Map<String, Object>> swqxzList = swqxzInfoService.getList();
        //多联室内机
        List<Map<String, Object>> dlsnjList = dlsnjInfoService.getList();
        //多联室外机
        List<Map<String, Object>> dlswjList = dlswjInfoService.getList();
        //风冷热泵机组
        List<Map<String, Object>> flrbList = flrbInfoService.getList();
        //机房空调
        List<Map<String, Object>> jfktpList = jfktpInfoService.getList();
        //排风机
        List<Map<String, Object>> pfjList = pfjInfoService.getList();
        //水泵
        List<Map<String, Object>> sbList = sbInfoService.getList();
        //室内机风柜
        List<Map<String, Object>> sljfgList = sljfgInfoService.getList();

        //多联新风处理机室内机
        List<Map<String, Object>> dlxfsnjList = dlxfsnjInfoService.getList();

        List<Map<String, Object>> snqxMaps = snqxzInfoHourService.getParamGroupByRegion(null);
        for (Map<String, Object> temp : snqxMaps) {
            if (Constants.STRING_1.equals(temp.get("region").toString())) {
                //候车大厅室内
                map.put("hcdtSnqx", temp);
            } else if (Constants.STRING_2.equals(temp.get("region").toString())) {
                //办公区域室内
                map.put("bgqySnqx", temp);
            }
        }
        //室内气象站
        map.put("snqxzList", snqxzList);
        //室外气象站
        map.put("swqxzList", swqxzList);
        //多联室内机
        map.put("dlsnjList", dlsnjList);
        //多联室外机
        map.put("dlswjList", dlswjList);
        //风冷热泵机组
        map.put("flrbList", flrbList);
        //机房空调(220V)
        map.put("jfktpList", jfktpList);
        //排风机
        map.put("pfjList", pfjList);
        //水泵
        map.put("sbList", sbList);
        //室内机风柜
        map.put("sljfgList", sljfgList);

        //多联新风处理机室内机
        map.put("dlxfsnjList", dlxfsnjList);
        //首页数据
        map.put("syBean", analysisService.getSyParam());
        return map;
    }

    /**
     * 首页接口
     *
     * @return
     */
    @Override
    public Map<String, Object> getList2(String startTime,String endTime,String resourceType) {
        SimpleDateFormat sdfLongTime = new SimpleDateFormat("yyyyMMddHH");
        String time = sdfLongTime.format(new Date());
        SimpleDateFormat sdfLongTime2 = new SimpleDateFormat("yyyyMMdd");
        String time2 = sdfLongTime2.format(new Date());

        Map<String, Object> map = new HashMap<String, Object>(32);


        //资阳西站室内环境参数
        List<Map<String, Object>> snqxzList = snqxzInfoService.getList2(time);


        //资阳西站室外气象参数
        List<Map<String, Object>> swqxzList = swqxzInfoService.getList2();


        //空调通风系统运行工况&运行参数
        //A区
        Map<String, Object> ktflrbMapA = new HashMap<>();
        //C区
        Map<String, Object> ktflrbMapC = new HashMap<>();
        //获取资源点信息
        List<LiResource> list = liResourceService.selectResourceList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (LiResource liResource : list) {
                if (liResource.getName().equals(Constants.KTJZ_A)) {
                    //根据资源点id查询当前时间的空调机组情况
                    ZyJfktpInfo zyJfktpInfo = zyJfktpInfoService.selectZyJfktpInfo(liResource.getId(), time);
                    if (zyJfktpInfo != null) {
                        ktflrbMapA.put("hfwd", zyJfktpInfo.getWindTem());
                    }
                } else if (liResource.getName().equals(Constants.FLRB_A)) {
                    //根据资源点id查询最近的风冷热泵机组情况
                    ZyFlrbInfo zyFlrbInfo = zyFlrbInfoService.selectZyFlrbInfo(liResource.getId(), time);
                    if (zyFlrbInfo != null) {
                        ktflrbMapA.put("gswd", zyFlrbInfo.getWaterSupplyTemperature());
                        ktflrbMapA.put("hswd", zyFlrbInfo.getReturnWaterTemperature());
                        ktflrbMapA.put("sll", zyFlrbInfo.getWaterRate());
                        ktflrbMapA.put("yxgk", zyFlrbInfo.getSwitchMode());
                    }
                } else if (liResource.getName().equals(Constants.KTJZ_C)) {
                    //根据资源点id查询当前时间的空调机组情况
                    ZyJfktpInfo zyJfktpInfo = zyJfktpInfoService.selectZyJfktpInfo(liResource.getId(), time);
                    if (zyJfktpInfo != null) {
                        ktflrbMapC.put("hfwd", zyJfktpInfo.getWindTem());
                    }
                } else if (liResource.getName().equals(Constants.FLRB_C)) {
                    //根据资源点id查询最近的风冷热泵机组情况
                    ZyFlrbInfo zyFlrbInfo = zyFlrbInfoService.selectZyFlrbInfo(liResource.getId(), time);
                    if (zyFlrbInfo != null) {
                        ktflrbMapC.put("gswd", zyFlrbInfo.getWaterSupplyTemperature());
                        ktflrbMapC.put("hswd", zyFlrbInfo.getReturnWaterTemperature());
                        ktflrbMapC.put("sll", zyFlrbInfo.getWaterRate());
                        ktflrbMapC.put("yxgk", zyFlrbInfo.getSwitchMode());
                    }
                }
            }
        }


        //空调通风系统能耗统计分析-总能耗
        Map<String, Object> totalEnergyMap = new HashMap<>();
        //根据时间查询空调机组采集数据表获取总能耗
        BigDecimal zyJfktpInfoEnergy = zyJfktpInfoService.getTotalEnergy(time2);
        totalEnergyMap.put("zyJfktpInfoEnergy",zyJfktpInfoEnergy);
        //根据时间查询风冷热泵机组采集数据表获取总能耗
        BigDecimal zyFlrbInfoEnergy = zyFlrbInfoService.getTotalEnergy(time2);
        totalEnergyMap.put("zyFlrbInfoEnergy",zyFlrbInfoEnergy);
        //根据时间查询空气处理机采集数据表获取总能耗
        BigDecimal kqcljInfoEnergy = kqcljInfoService.getTotalEnergy(time2);
        totalEnergyMap.put("kqcljInfoEnergy",kqcljInfoEnergy);

        if(StringUtils.isEmpty(startTime)){
            startTime = time2;
        }
        if(StringUtils.isEmpty(endTime)){
            endTime = time2;
        }
        if(StringUtils.isEmpty(resourceType)){
            resourceType = Constants.ZY_KTJZ;
        }
        //资阳西站室内环境参数
        map.put("snqxzList", snqxzList);
        //资阳西站室外气象参数
        map.put("swqxzList", swqxzList);
        //空调通风系统运行工况&运行参数
        map.put("a", ktflrbMapA);
        map.put("c", ktflrbMapC);
        //空调通风系统能耗统计分析-总能耗
        map.put("totalEnergyMap", totalEnergyMap);
        //空调通风系统能耗统计分析
        map.put("energyInfoMap", analysisService.getZyEnergyFx(startTime, endTime, resourceType));
        return map;
    }
}
