package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.common.utils.ExportExcel2;
import com.devplatform.admin.modules.eq.bean.ExcelInfo;
import com.devplatform.admin.modules.eq.bean.JfktpInfo;
import com.devplatform.admin.modules.eq.dao.JfktpInfoDao;
import com.devplatform.admin.modules.eq.model.JfktpInfoModel;
import com.devplatform.admin.modules.eq.service.JfktpInfoDayService;
import com.devplatform.admin.modules.eq.service.JfktpInfoHourService;
import com.devplatform.admin.modules.eq.service.JfktpInfoMonthService;
import com.devplatform.admin.modules.eq.service.JfktpInfoService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 机房空调(220V)信息的service接口实现类
 * <br>
 * <b>功能：</b>JfktpInfoServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("jfktpInfoService")
public class JfktpInfoServiceImpl extends MyBaseServiceImpl<JfktpInfoDao, JfktpInfo> implements JfktpInfoService {
    @Autowired
    private JfktpInfoHourService jfktpInfoHourService;
    @Autowired
    private JfktpInfoDayService jfktpInfoDayService;
    @Autowired
    private JfktpInfoMonthService jfktpInfoMonthService;


    @Override
    public List<JfktpInfo> queryPageList(JfktpInfoModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }

    @Override
    public List<Map<String, Object>> getList() {
        return baseMapper.getList();
    }

    @Override
    public Page<Map<String, Object>> queryPageListByParam(Page<Map<String, Object>> pageTask, Map<String, Object> params) {
        String startTime = (String) params.get("startTime");
        String endTime = (String) params.get("endTime");
        int type = DateUtil.checkTimeToType(startTime,endTime);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        if(type == Constants.INT_1){
            page = jfktpInfoHourService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_2|| type == Constants.INT_3){
            page = jfktpInfoDayService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_4){
            page = jfktpInfoMonthService.queryPageListByParam(pageTask,params);
        }
        return page;
    }

    @Override
    public List<Map<String, Object>> queryListByParam(String startTime,String endTime) {
        List<Map<String,Object>> list = new ArrayList<>();
        //int type = DateUtil.checkTimeToType(startTime,endTime);
        int type = 1;
        if(type == Constants.INT_1){
            list = jfktpInfoHourService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_2|| type == Constants.INT_3){
            list = jfktpInfoDayService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_4){
            list = jfktpInfoMonthService.queryListByParam(startTime,endTime);
        }
        return list;
    }

    @Override
    public void toExcel(HttpServletResponse response, Map<String, Object> params) {
        OutputStream out = null;
        try {
            String startTime = (String) params.get("startTime");
            String endTime = (String) params.get("endTime");
            int type = DateUtil.checkTimeToType(startTime,endTime);
            List<ExcelInfo> list = new ArrayList<>();
            if(type == Constants.INT_1){
                list = jfktpInfoHourService.queryList(params);
            }else if(type == Constants.INT_2 || type == Constants.INT_3){
                list = jfktpInfoDayService.queryList(params);
            }else if(type == Constants.INT_4){
                list = jfktpInfoMonthService.queryList(params);
            }

            String fileName = "kt.xlsx";
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            out = response.getOutputStream();

            Map<String, Object> map = new HashMap<>();
            map.put("title", "空调历史记录");
            List<String> strList = new ArrayList<>();
            strList.add("序号");
            strList.add("设备名称");
            strList.add("设备编号");
            strList.add("用电量");
            strList.add("采集时间");
            map.put("titles", strList);

            map.put("list", list);
            ExportExcel2 ee = new ExportExcel2(map);
            ee.export(out);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

}
