package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.eq.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 数据看板的service接口实现类
 * @author dxw
 */
@Service("kanBanService")
public class KanBanServiceImpl implements KanBanService {
    @Autowired
    private FlrbInfoService flrbInfoService;
    @Autowired
    private JfktpInfoService jfktpInfoService;
    @Autowired
    private PfjInfoService pfjInfoService;
    @Autowired
    private SnqxzInfoHourService snqxzInfoHourService;
    @Autowired
    private SwqxzInfoHourService swqxzInfoHourService;
    @Autowired
    private DlswjInfoService dlswjInfoService;
    @Autowired
    private SljfgInfoService sljfgInfoService;
    @Autowired
    private SbInfoService sbInfoService;

    @Override
    public Page<Map<String,Object>> getListByTypeAndId(Map<String, Object> params) {
        Page<Map<String,Object>> list = new Page<Map<String,Object>>();
        String page = (String) params.get("page");
        String rows = (String) params.get("rows");
        String resourceType = (String) params.get("resourceType");
        Page<Map<String,Object>> pageTask = new Page<Map<String, Object>>(Integer.valueOf(page), Integer.valueOf(rows));

        if(Constants.ID_PFJ.equals(resourceType)){
            list = pfjInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_JFKTP.equals(resourceType)){
            list = jfktpInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_JLM.equals(resourceType)){

        }else if(Constants.ID_FLRBJZ.equals(resourceType)){
            list = flrbInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SLJFG.equals(resourceType)){
            list = sljfgInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SB.equals(resourceType)){
            list = sbInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SWQXZ.equals(resourceType)){
            list = swqxzInfoHourService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_DLSNJ.equals(resourceType)){

        }else if(Constants.ID_SLSWJ.equals(resourceType)){
            list = dlswjInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SNQXZ.equals(resourceType)){
            list = snqxzInfoHourService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_FYC.equals(resourceType)){

        }else if(Constants.ID_DLXFSNJ.equals(resourceType)){

        }
        return list;
    }

    @Override
    public void toExcel(HttpServletResponse response, Map<String, Object> params) {
        String resourceType = (String) params.get("resourceType");

        if(Constants.ID_PFJ.equals(resourceType)){
            pfjInfoService.toExcel(response,params);
        }else if(Constants.ID_JFKTP.equals(resourceType)){
            jfktpInfoService.toExcel(response,params);
        }else if(Constants.ID_FLRBJZ.equals(resourceType)){
            flrbInfoService.toExcel(response,params);
        }else if(Constants.ID_SB.equals(resourceType)){
            sbInfoService.toExcel(response,params);
        }else if(Constants.ID_SWQXZ.equals(resourceType)){
            swqxzInfoHourService.toExcel(response,params);
        }else if(Constants.ID_SLSWJ.equals(resourceType)){
            dlswjInfoService.toExcel(response,params);
        }else if(Constants.ID_SNQXZ.equals(resourceType)){
            snqxzInfoHourService.toExcel(response,params);
        }
    }
}
