package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.ExportSnqxzExcel;
import com.devplatform.admin.modules.eq.bean.SnqxzInfoHour;
import com.devplatform.admin.modules.eq.dao.SnqxzInfoHourDao;
import com.devplatform.admin.modules.eq.model.SnqxzInfoHourModel;
import com.devplatform.admin.modules.eq.service.SnqxzInfoHourService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 室内气象站信息-时的service接口实现类
 * <br>
 * <b>功能：</b>SnqxzInfoHourServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("snqxzInfoHourService")
public class SnqxzInfoHourServiceImpl extends MyBaseServiceImpl<SnqxzInfoHourDao, SnqxzInfoHour> implements SnqxzInfoHourService {

    @Override
    public List<SnqxzInfoHour> queryPageList(SnqxzInfoHourModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }
    @Override
    public Page<Map<String, Object>> queryPageListByParam(Page<Map<String, Object>> page, Map<String, Object> params) {
        return baseMapper.queryPageListByParam(page,params);
    }

    @Override
    public List<Map<String,Object>> getList(String resourceId, String startTime,String endTime) {
        return baseMapper.getList(resourceId,startTime,endTime);
    }

    @Override
    public List<Map<String, Object>> getListFx(Integer region, String startTime,String endTime) {
        return baseMapper.getListFx(region,startTime,endTime);
    }

    @Override
    public List<Map<String, Object>> getParamGroupByRegion(Integer region) {
        return baseMapper.getParamGroupByRegion(region);
    }

    @Override
    public void toExcel(HttpServletResponse response, Map<String, Object> params) {
        OutputStream out = null;
        try {
            List<SnqxzInfoHour> list = baseMapper.queryList(params);;

            String fileName = "snqxz.xlsx";
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            out = response.getOutputStream();

            Map<String, Object> map = new HashMap<>();
            map.put("title", "传感器历史记录");
            List<String> strList = new ArrayList<>();
            strList.add("序号");
            strList.add("设备名称");
            strList.add("设备编号");
            strList.add("温度（℃）");
            strList.add("湿度（%RH）");
            strList.add("CO2（PPM）");
            strList.add("采集时间");
            map.put("titles", strList);

            map.put("list", list);
            ExportSnqxzExcel ee = new ExportSnqxzExcel(map);
            ee.export(out);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
