package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.ExportSwqxzExcel;
import com.devplatform.admin.modules.eq.bean.SwqxzInfoHour;
import com.devplatform.admin.modules.eq.dao.SwqxzInfoHourDao;
import com.devplatform.admin.modules.eq.model.SwqxzInfoHourModel;
import com.devplatform.admin.modules.eq.service.SwqxzInfoHourService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 室外气象站信息-时的service接口实现类
 * <br>
 * <b>功能：</b>SwqxzInfoHourServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("swqxzInfoHourService")
public class SwqxzInfoHourServiceImpl extends MyBaseServiceImpl<SwqxzInfoHourDao, SwqxzInfoHour> implements SwqxzInfoHourService {

    @Override
    public List<SwqxzInfoHour> queryPageList(SwqxzInfoHourModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }

    @Override
    public List<SwqxzInfoHour> getList(String startTime,String endTime) {
        return baseMapper.getList(startTime,endTime);
    }

    @Override
    public Page<Map<String, Object>> queryPageListByParam(Page<Map<String, Object>> page, Map<String, Object> params) {
        return baseMapper.queryPageListByParam(page,params);
    }

    @Override
    public void toExcel(HttpServletResponse response, Map<String, Object> params) {
        OutputStream out = null;
        try {
            List<SwqxzInfoHour> list = baseMapper.queryList(params);;

            String fileName = "swqxz.xlsx";
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            out = response.getOutputStream();

            Map<String, Object> map = new HashMap<>();
            map.put("title", "室外气象站历史记录");
            List<String> strList = new ArrayList<>();
            strList.add("序号");
            strList.add("设备名称");
            strList.add("设备编号");
            strList.add("温度(℃)");
            strList.add("湿度(%RH)");
            strList.add("风速(m/s)");
            strList.add("光照(Lux)");
            strList.add("CO2（PPM）");
            strList.add("PM2.5(ug/m)");
            strList.add("辐射(w/m)");
            strList.add("采集时间");
            map.put("titles", strList);

            map.put("list", list);
            ExportSwqxzExcel ee = new ExportSwqxzExcel(map);
            ee.export(out);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

}
