package com.devplatform.admin.modules.generation.bean;

import com.devplatform.admin.modules.generation.util.FieldModel;
import com.devplatform.admin.modules.generation.util.ValidateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

/**
 * @author Administrator
 */
@ApiModel(value = "代码生成对象", description = "代码生成对象")
public class CreateJavaModel {

  @ApiModelProperty(value = "数据库类型", name = "dbType")
	/** 数据库类型*/
  private int dbType; 

  @ApiModelProperty(value = "数据库ip", name = "ip")
	/** 数据库ip*/
  private String ip; 

  @ApiModelProperty(value = "数据库端口", name = "port")
	/** 数据库端口*/
  private String port; 

  @ApiModelProperty(value = "数据库名称", name = "dbName")
	/** 数据库名称*/
  private String dbName; 

  @ApiModelProperty(value = "用户名", name = "username")
	/** 用户名*/
  private String username; 

  @ApiModelProperty(value = "密码", name = "dbpwd")
	/** 密码*/
  private String dbpwd; 

  @ApiModelProperty(value = "要生成的表名", name = "tableName")
	/** 要生成的表名*/
  private String tableName; 

  @ApiModelProperty(value = "表名前缀", name = "pfix")
	/** 表名前缀*/
  private String pfix; 

  @ApiModelProperty(value = "表备注信息", name = "tableRemark")
	/** 表备注信息*/
  private String tableRemark; 

  @ApiModelProperty(value = "生成java文件的存放路径", name = "devPath")
	/** 生成文件的存放路径*/
  private String javaDevPath; 

  @ApiModelProperty(value = "生成xml文件的存放路径", name = "devPath")
	/** 生成文件的存放路径*/
  private String xmlDevPath; 

  @ApiModelProperty(value = "模板地址", name = "templateFolder")
	/** 模板地址*/
  private String templateFolder; 

  private String currentIndex;

	/** 是否生成菜单*/
  private String isShwoMenu; 

  private String isAddJsp;

  private String isBean;

  private String isController;

  private String isEditjsp;

  private String isJs;

  private String isListJsp;

  private String isMapperJava;

  private String isMapperXml;

  private String isService;

  private String isModel;

  private String className;

  private String classOracleName;

  private String lowerName;

  private String lowerOracleName;

  private String pacageName;

  @ApiModelProperty(value = "模块名称", name = "modulesName")
	/** 模块名称*/
  private String modulesName; 

  @ApiModelProperty(value = "表字段的集合", name = "fields")
	/** 列的集合*/
  private List<FieldModel> fields; 

  @ApiModelProperty(value = "表字段的集合", name = "jsonString")
	/** 列集合*/
  private String jsonString; 

  public String getLowerName() {
    String tempName = String.valueOf(this.tableName).toLowerCase();
    if (tempName != null) {
      if (ValidateUtil.isNotEmpty(pfix)) {
        tempName = tempName.replaceAll(pfix.toLowerCase(), "");
      }
      StringBuffer sb = new StringBuffer(tempName.length());
      String tableNew = tempName.toLowerCase();
      String[] tables = tableNew.split("_");
      String temp = null;
      for (int i = 0; i < tables.length; i++) {
        temp = tables[i].trim();
        sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1));
      }
      lowerName = sb.toString();
      lowerName = lowerName.substring(0, 1).toLowerCase() + lowerName.substring(1);
    }
    return lowerName;
  }

  public void setLowerName(String lowerName) {
    this.lowerName = lowerName;
  }

  public String getClassName() {
    String tempName = String.valueOf(this.tableName).toLowerCase();
    if (tempName != null) {
      if (ValidateUtil.isNotEmpty(pfix)) {
        tempName = tempName.replaceAll(pfix.toLowerCase(), "");
      }
      StringBuffer sb = new StringBuffer(tempName.length());
      String tableNew = tempName.toLowerCase();
      String[] tables = tableNew.split("_");
      String temp = null;
      for (int i = 0; i < tables.length; i++) {
        temp = tables[i].trim();
        sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1));
      }
      className = sb.toString();
    }
    return className;
  }

  public void setClassName(String className) {
    this.className = className;
  }

  public String getJavaDevPath() {
    return javaDevPath;
  }

  public void setJavaDevPath(String javaDevPath) {
    this.javaDevPath = javaDevPath;
  }

  public String getXmlDevPath() {
    return xmlDevPath;
  }

  public void setXmlDevPath(String xmlDevPath) {
    this.xmlDevPath = xmlDevPath;
  }

  public int getDbType() {
    return dbType;
  }

  public void setDbType(int dbType) {
    this.dbType = dbType;
  }

  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public String getPort() {
    return port;
  }

  public void setPort(String port) {
    this.port = port;
  }

  public String getDbName() {
    return dbName;
  }

  public void setDbName(String dbName) {
    this.dbName = dbName;
  }

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getDbpwd() {
    return dbpwd;
  }

  public void setDbpwd(String dbpwd) {
    this.dbpwd = dbpwd;
  }

  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public String getPfix() {
    return pfix;
  }

  public void setPfix(String pfix) {
    this.pfix = pfix;
  }

  public String getTableRemark() {
    return tableRemark;
  }

  public void setTableRemark(String tableRemark) {
    this.tableRemark = tableRemark;
  }

  public String getIsShwoMenu() {
    return isShwoMenu;
  }

  public void setIsShwoMenu(String isShwoMenu) {
    this.isShwoMenu = isShwoMenu;
  }

  public String getCurrentIndex() {
    return currentIndex;
  }

  public void setCurrentIndex(String currentIndex) {
    this.currentIndex = currentIndex;
  }

  public List<FieldModel> getFields() {
    return fields;
  }

  public void setFields(List<FieldModel> fields) {
    this.fields = fields;
  }

  public String getIsAddJsp() {
    return isAddJsp;
  }

  public void setIsAddJsp(String isAddJsp) {
    this.isAddJsp = isAddJsp;
  }

  public String getIsBean() {
    return isBean;
  }

  public void setIsBean(String isBean) {
    this.isBean = isBean;
  }

  public String getIsController() {
    return isController;
  }

  public void setIsController(String isController) {
    this.isController = isController;
  }

  public String getIsEditjsp() {
    return isEditjsp;
  }

  public void setIsEditjsp(String isEditjsp) {
    this.isEditjsp = isEditjsp;
  }

  public String getIsJs() {
    return isJs;
  }

  public void setIsJs(String isJs) {
    this.isJs = isJs;
  }

  public String getIsListJsp() {
    return isListJsp;
  }

  public void setIsListJsp(String isListJsp) {
    this.isListJsp = isListJsp;
  }

  public String getIsMapperJava() {
    return isMapperJava;
  }

  public void setIsMapperJava(String isMapperJava) {
    this.isMapperJava = isMapperJava;
  }

  public String getIsMapperXml() {
    return isMapperXml;
  }

  public void setIsMapperXml(String isMapperXml) {
    this.isMapperXml = isMapperXml;
  }

  public String getIsService() {
    return isService;
  }

  public void setIsService(String isService) {
    this.isService = isService;
  }

  public String getIsModel() {
    return isModel;
  }

  public void setIsModel(String isModel) {
    this.isModel = isModel;
  }

  public String getTemplateFolder() {
    return templateFolder;
  }

  public void setTemplateFolder(String templateFolder) {
    this.templateFolder = templateFolder;
  }

  public String getClassOracleName() {
    String tempName = String.valueOf(this.tableName).toLowerCase();
    if (tempName != null) {
      StringBuffer sb = new StringBuffer(tempName.length());
      String tableNew = tempName.toLowerCase();
      String[] tables = tableNew.split("_");
      String temp = null;
      for (int i = 0; i < tables.length; i++) {
        temp = tables[i].trim();
        sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1));
      }
      classOracleName = sb.toString();
    }
    return classOracleName;
  }

  public void setClassOracleName(String classOracleName) {
    this.classOracleName = classOracleName;
  }

  public String getPacageName() {
     //设置包名
    String pacageName =
        this.javaDevPath.substring(this.javaDevPath.indexOf("\\src\\main\\java\\") + 15);
    pacageName = pacageName.replace("\\", ".");
    return pacageName;
  }

  public void setPacageName(String pacageName) {
    this.pacageName = pacageName;
  }

  public String getLowerOracleName() {

    String tempName = String.valueOf(this.tableName).toLowerCase();
    tempName = tempName.substring(tempName.indexOf("_") + 1, tempName.length());
    if (tempName != null) {
      StringBuffer sb = new StringBuffer(tempName.length());
      String tableNew = tempName.toLowerCase();
      String[] tables = tableNew.split("_");
      String temp = null;
      for (int i = 0; i < tables.length; i++) {
        temp = tables[i].trim();
        sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1));
      }
      lowerOracleName = sb.toString();
      lowerOracleName =
          lowerOracleName.substring(0, 1).toLowerCase() + lowerOracleName.substring(1);
    }
    return lowerOracleName;
  }

  public void setLowerOracleName(String lowerOracleName) {
    this.lowerOracleName = lowerOracleName;
  }

  public String getModulesName() {
    return modulesName;
  }

  public void setModulesName(String modulesName) {
    this.modulesName = modulesName;
  }

  public String getJsonString() {
    return jsonString;
  }

  public void setJsonString(String jsonString) {
    this.jsonString = jsonString;
  }
}
