package com.devplatform.admin.modules.liresource.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @author Administrator
 */
@ApiModel(value = "资源点管理表对象", description = "资源点管理表对象")
@TableName("li_resource")
@Data
public class LiResource implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID", name = "id")
    @TableId
    /** 主键id*/
    private java.lang.String id;

    @ApiModelProperty(value = "资源点名称", name = "name")
    /** 资源点名称*/
    private java.lang.String name;

    @ApiModelProperty(value = "资源点编码", name = "code")
    /** 资源点编码*/
    private java.lang.String code;

    @ApiModelProperty(value = "资源点类型(数据字典id)", name = "type")
    /** 资源点类型(数据字典id)*/
    private java.lang.String type;

    @ApiModelProperty(value = "所属区域(1候车大厅，2办公区域，3屋顶)", name = "region")
    /** 所属区域(1候车大厅，2办公区域，3屋顶)*/
    private Integer region;

    @ApiModelProperty(value = "品牌", name = "brand")
    /** 品牌*/
    private java.lang.String brand;

    @ApiModelProperty(value = "资源点型号", name = "equipmentModel")
    /** 资源点型号*/
    private java.lang.String equipmentModel;

    @ApiModelProperty(value = "最大功率", name = "maxPower")
    /** 最大功率*/
    private java.lang.String maxPower;

    @ApiModelProperty(value = "安装日期", name = "installDate")
    /** 安装日期*/
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private java.util.Date installDate;

    @ApiModelProperty(value = "维保日期", name = "maintenanceDate")
    /** 维保日期*/
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private java.util.Date maintenanceDate;

    @ApiModelProperty(value = "站点ID", name = "stationId")
    /** 站点ID*/
    private java.lang.String stationId;

    @ApiModelProperty(value = "站点名称", name = "stationName")
    /** 站点名称*/
    private java.lang.String stationName;

    @ApiModelProperty(value = "站层id(li_station_map表id)", name = "tierId")
    /** 站层id(li_station_map表id)*/
    private java.lang.String tierId;

    @ApiModelProperty(value = "地址码", name = "addressCode")
    /** 地址码*/
    private java.lang.String addressCode;

    @ApiModelProperty(value = "端口号", name = "port")
    /** 端口号*/
    private java.lang.String port;

    @ApiModelProperty(value = "用户名", name = "username")
    /** 用户名*/
    private java.lang.String username;

    @ApiModelProperty(value = "密码", name = "password")
    /** 密码*/
    private java.lang.String password;

    @ApiModelProperty(value = "x轴坐标", name = "xpoint")
    /** x轴坐标*/
    private java.lang.String xpoint;

    @ApiModelProperty(value = "y轴坐标", name = "ypoint")
    /** y轴坐标*/
    private java.lang.String ypoint;

    @ApiModelProperty(value = "宽度", name = "width")
    /** 宽度*/
    private java.lang.String width;

    @ApiModelProperty(value = "旋转参数", name = "rotate")
    /** 旋转参数*/
    private java.lang.String rotate;

    @ApiModelProperty(value = "部署位置", name = "deployLocation")
    /** 部署位置*/
    private java.lang.String deployLocation;

    @ApiModelProperty(value = "当前操作员id", name = "operatorId")
    /** 当前操作员id*/
    private java.lang.String operatorId;

    @ApiModelProperty(value = "当前操作员姓名", name = "operatorName")
    /** 当前操作员姓名*/
    private java.lang.String operatorName;

    @ApiModelProperty(value = "附属信息", name = "attachedInfo")
    /** 附属信息*/
    private java.lang.String attachedInfo;

    @ApiModelProperty(value = "资源点简介", name = "remark")
    /** 资源点简介*/
    private java.lang.String remark;

    @ApiModelProperty(value = "资源点图标", name = "icon")
    /** 图标*/
    private java.lang.String icon;

    @ApiModelProperty(value = "资源点状态(1在线，2离线，3故障)", name = "status")
    /** 资源点状态(1在线，2离线，3故障)*/
    private Integer status;

    @ApiModelProperty(value = "是否已删除（0未删除，1已删除）", name = "deleted")
    /** 是否已删除（0未删除，1已删除）*/
    private Integer deleted;

    @ApiModelProperty(value = "创建人", name = "createUserId")
    /** 创建人*/
    private java.lang.String createUserId;

    @ApiModelProperty(value = "创建时间", name = "createTime")
    /** 创建时间*/
    private java.util.Date createTime;

    @ApiModelProperty(value = "修改人", name = "updateUserId")
    /** 修改人*/
    private java.lang.String updateUserId;

    @ApiModelProperty(value = "修改时间", name = "updateTime")
    /** 修改时间*/
    private java.util.Date updateTime;

    @ApiModelProperty(value = "备用项1", name = "byx1")
    /** 备用项1*/
    private java.lang.String byx1;

    @ApiModelProperty(value = "备用项2", name = "byx2")
    /** 备用项2*/
    private java.lang.String byx2;

    @ApiModelProperty(value = "备用项3", name = "byx3")
    /** 备用项3*/
    private java.lang.String byx3;

    @ApiModelProperty(value = "经度", name = "xlongit")
    /** 经度*/
    private java.lang.String xlongit;

    @ApiModelProperty(value = "纬度", name = "ylat")
    /** 纬度*/
    private java.lang.String ylat;

    @ApiModelProperty(value = "图标路径", name = "image_src")
    /** 图标路径*/
    private java.lang.String imageSrc;

    @ApiModelProperty(value = "人工模式", name = "mode_types")
    /** 人工模式*/
    private java.lang.String modeTypes;

    @TableField(exist = false)
    /** 地图层级*/
    private String tierName;

    @TableField(exist = false)
    /** 图标路径*/
    private String iconPath;

    @TableField(exist = false)
    /** 资源点类型名称*/
    private String resourceName;

    @TableField(exist = false)
    /** 品牌名称*/
    private String brandName;

    @TableField(exist = false)
    /** 资源点编码的前缀*/
    private String codeType;

    @TableField(exist = false)
    /** 添加还是修改*/
    private String addOrUpdate;

    @TableField(exist = false)
	/** 资源点状态*/
    private String statusName;

}
