package com.devplatform.admin.modules.liresource.dao;

import com.devplatform.admin.modules.liresource.bean.LiResource;
import com.devplatform.admin.modules.liresource.model.LiResourceModel;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * LiResource Mapper 用于资源点管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiResourceDao extends MyBaseMapper<LiResource> {

    /**
     * 查询资源点数量
     * @param model
     * @return
     */
    Integer queryPageByCount(LiResourceModel model);

    /**
     * 查询资源点数据
     * @param model
     * @return
     */
    List<LiResource> queryPageByList(LiResourceModel model);

    /**
     * 查询资源点树信息
     * @param model
     * @return
     */
    List<LiResource> getTreeList(LiResourceModel model);

    /**
     * 根据id查询资源点信息
     * @param id
     * @param stationId
     * @return
     */
    LiResource getBeanById(@Param("id") String id, @Param("stationId") String stationId);

    /**
     * 查询图层中资源点的数量
     * @param tierId
     * @return
     */
    Integer queryCountByTierId(String tierId);

    /**
     * 根据资源点编码查询资源点
     * @param code
     * @return
     */
    LiResource queryByCode(String code);

    /**
     * 查询人工模式下的所有资源点
     * @param modeTypes
     * @return
     */
    List<LiResource> queryListByParam(String modeTypes);

    List<LiResource> selectResourceList();
}
