package com.devplatform.admin.modules.liresource.service;

import com.devplatform.admin.modules.liresource.bean.LiStationMap;
import com.devplatform.admin.modules.liresource.model.LiStationMapModel;
import com.devplatform.common.service.MyBaseService;
import java.util.List;

/**
 * 线路站点地图附件表的service接口 <br>
 * <b>功能：</b>LiStationMapService<br>
 *
 * @author 代码生成器产生
 */
public interface LiStationMapService extends MyBaseService<LiStationMap> {

  /**
   * 查询站点地图
   *
   * @param model
   * @return
   */
  List<LiStationMap> getTreeList(LiStationMapModel model);

  /**
   * 逻辑删除站点地图
   * @param list
   * @param sysSign
   */
  void deleteByIds(List<String> list, String sysSign);

  /**
   * 查询站点所有地图
   *
   * @param stationId
   * @return
   */
  List<LiStationMap> getListByStationId(String stationId);

  /**
   * 查询地图
   *
   * @param id
   * @return
   */
  LiStationMap getById(String id);

  /**
   * 批量更新地图
   * @param stationId
   * @param list
   * @param sysSign
   */
  void saveOrUpdateBatch(String stationId, List<LiStationMap> list, String sysSign);
}
