package com.devplatform.admin.modules.liresource.service;

import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.model.LiStationModel;
import com.devplatform.common.service.MyBaseService;
import java.util.List;
import java.util.Map;

/**
 * 线路站点管理表的service接口 <br>
 * <b>功能：</b>LiStationService<br>
 *
 * @author 代码生成器产生
 */
public interface LiStationService extends MyBaseService<LiStation> {
  /**
   * 分页数据查询方法
   *
   * @param model
   * @return
   */
  List<LiStation> queryPageByList(LiStationModel model);

  /**
   * 查询站点树
   *
   * @param model
   * @return
   */
  List<LiStation> getTreeList(LiStationModel model);

  /**
   * 保存站点信息
   *
   * @param bean
   */
  void saveStation(LiStation bean);

  /**
   * 修改站点信息
   *
   * @param bean
   */
  void updateStation(LiStation bean);

  /**
   * 站点接管管理列表页数据
   *
   * @param model
   * @return
   */
  List<Map<String, Object>> queryPageByListTakeover(LiStationModel model);
}
