package com.devplatform.admin.modules.liresource.service.impl;

import org.springframework.stereotype.Service;

import com.devplatform.admin.modules.liresource.model.LiResourcePointsModel;
import com.devplatform.admin.modules.liresource.bean.LiResourcePoints;
import com.devplatform.admin.modules.liresource.dao.LiResourcePointsDao;
import com.devplatform.admin.modules.liresource.service.LiResourcePointsService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 点位维护表的service接口实现类
 * <br>
 * <b>功能：</b>LiResourcePointsServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("liResourcePointsService")
public class LiResourcePointsServiceImpl extends MyBaseServiceImpl<LiResourcePointsDao, LiResourcePoints> implements LiResourcePointsService {

    @Override
    public List<LiResourcePoints> queryPageList(LiResourcePointsModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }

    @Override
    public void deleteByFlagByIds(String[] ids, String userId){
        //用来暂存所有要删除的对象
        List<LiResourcePoints> beans = new ArrayList<LiResourcePoints>();
        //遍历ids数组
        for(String id: ids){
            LiResourcePoints temp = new LiResourcePoints();
            temp.setId(id);
            //将数据标记为删除
            temp.setDeleted(1);
            temp.setUpdateUserId(userId);
            temp.setUpdateTime(new Date());
            //将要删除的对象存放在list中
            beans.add(temp);
        }
        //调用批量更新操作
        updateBatchById(beans);
    }
}
