package com.devplatform.admin.modules.liresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.modules.liresource.bean.LiStationMap;
import com.devplatform.admin.modules.liresource.dao.LiStationMapDao;
import com.devplatform.admin.modules.liresource.model.LiStationMapModel;
import com.devplatform.admin.modules.liresource.service.LiStationMapService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 线路站点地图附件表的service接口实现类 <br>
 * <b>功能：</b>LiStationMapServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liStationMapService")
public class LiStationMapServiceImpl extends MyBaseServiceImpl<LiStationMapDao, LiStationMap>
    implements LiStationMapService {

  @Override
  public List<LiStationMap> getTreeList(LiStationMapModel model) {
    return baseMapper.getTreeList(model);
  }

  @Override
  public void deleteByIds(List<String> list, String sysSign) {
    baseMapper.deleteByIds(list, sysSign);
  }

  @Override
  public List<LiStationMap> getListByStationId(String stationId) {
    return baseMapper.getListByStationId(stationId);
  }

  @Override
  public LiStationMap getById(String id) {
    return baseMapper.selectOne(new QueryWrapper<LiStationMap>().eq("id", id));
  }

  @Override
  public void saveOrUpdateBatch(String stationId, List<LiStationMap> list, String sysSign) {
    if (list != null && list.size() > 0) {
      list.forEach(
          (stationMap) -> {
            stationMap.setStationId(stationId);
            stationMap.setDeleted(0);
            stationMap.setSysSign(sysSign);
            if (StringUtil.checkNotNull(stationMap.getId())) {
              baseMapper.updateById(stationMap);
            } else {
              baseMapper.insert(stationMap);
            }
          });
    }
  }
}
