package com.devplatform.admin.modules.socket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;
/**
 * @author Administrator
 */
@Component
@ServerEndpoint("/push/websocket")
public class WebSocketServer {
  /** 存储二维码维一标识*/
  public static Map<String, Object> sessions = new HashMap<>();
  /** 静态变量，用来记录当前在线连接数。应该把它设计成线程安全的。*/
  private static int onlineCount = 0;
  /** concurrent包的线程安全Set，用来存放每个客户端对应的MyWebSocket对象。*/
  private static CopyOnWriteArraySet<WebSocketServer> webSocketSet =
      new CopyOnWriteArraySet<WebSocketServer>();
  /** 与某个客户端的连接会话，需要通过它来给客户端发送数据*/
  private Session session;

  public static synchronized int getOnlineCount() {
    return onlineCount;
  }

  public static synchronized void addOnlineCount() {
    WebSocketServer.onlineCount++;
  }

  public static synchronized void subOnlineCount() {
    WebSocketServer.onlineCount--;
  }

  /** 连接建立成功调用的方法 */
  @OnOpen
  public void onOpen(Session session) throws Exception {
    System.out.println("连接成功;");
    this.session = session;
    // 生成唯一ID
    String uuid = String.valueOf(UUID.randomUUID());
    // 把唯一标识跟客户端绑定
    sessions.put(uuid, this.session);
    // 加入set中
    webSocketSet.add(this);
    // 在线数加1
    addOnlineCount();
    System.out.println("有新连接加入！当前在线人数为" + getOnlineCount());
  }

  /** 连接关闭调用的方法 */
  @OnClose
  public void onClose() {
    // 从set中删除
    webSocketSet.remove(this);
    // 在线数减1
    subOnlineCount();
    System.out.println("有一连接关闭！当前在线人数为" + getOnlineCount());
    System.out.println(webSocketSet);
  }

  /**
   * 收到客户端消息后调用的方法
   *
   * @param message 客户端发送过来的消息
   */
  @OnMessage
  public void onMessage(String message, Session session) {
    System.out.println("来自客户端的消息:" + message);
    try {
      session.getBasicRemote().sendText(message);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * 发生错误时调用
   *
   * @param session
   * @param error
   */
  @OnError
  public void onError(Session session, Throwable error) {
    System.out.println("发生错误");
    error.printStackTrace();
  }

  public void sendMessage(String message, Session session) throws IOException {
    for (WebSocketServer webSocket : webSocketSet) {
      System.out.println("【websocket消息】广播消息:" + message);
      try {
        webSocket.session.getAsyncRemote().sendText(message);
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    // System.out.println(session);
    // session.getBasicRemote().sendText(message);
    // this.session.getAsyncRemote().sendText(message);

  }

  /** Qzli 2018/06/25 自定义发送消息（解决广播式发送消息的问题） */
  public void sendInfo(Object message, String uid) throws IOException {
    System.out.println(webSocketSet);
    try {
      sendMessage(message.toString(), (Session) sessions.get(uid));
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebSocketServer that = (WebSocketServer) o;
    return Objects.equals(session, that.session);
  }

  @Override
  public int hashCode() {
    return Objects.hash(session);
  }
}
