package com.devplatform.admin.modules.sys.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * 菜单管理
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:26:39
 */
@ApiModel(value = "角色对象", description = "角色对象")
@TableName("sys_menu")
public class SysMenuEntity implements Serializable {

  private static final long serialVersionUID = 1L;

  /** 父菜单名称*/
  @ApiModelProperty(value = "父菜单名称", name = "parentName")
  @TableField(exist = false)
  private String parentName;

  /** 菜单PATH*/
  @ApiModelProperty(value = "菜单PATH", name = "path")
  @TableField(exist = false)
  private String path;

  /** ztree属性*/
  @TableField(exist = false)
  private Boolean open;

  @ApiModelProperty("主键menu_id")
  @TableId
  private String menuId;

  @ApiModelProperty("父菜单id，一级菜单为0")
  private String parentId;

  @ApiModelProperty("菜单名称")
  private String name;

  @ApiModelProperty("菜单url")
  private String url;

  @ApiModelProperty("授权(多个用逗号分隔，如：user:list，user:create)")
  private String perms;

  @ApiModelProperty("类型(0：目录1：菜单，2：按钮)")
  private Integer type;

  @ApiModelProperty("菜单图标")
  private String icon;

  @ApiModelProperty("排序")
  private Integer orderNum;

  @ApiModelProperty("是否系统菜单(1：是 0：否)")
  private String isSystemMenu;

  @ApiModelProperty("0=启动；1=禁用")
  private Integer status;

  @ApiModelProperty("系统标识")
  private String sysSign;

  private String stationId;

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentName) {
    this.parentName = parentName;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public Boolean getOpen() {
    return open;
  }

  public void setOpen(Boolean open) {
    this.open = open;
  }

  public String getMenuId() {
    return menuId;
  }

  public void setMenuId(String menuId) {
    this.menuId = menuId;
  }

  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getPerms() {
    return perms;
  }

  public void setPerms(String perms) {
    this.perms = perms;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getIcon() {
    return icon;
  }

  public void setIcon(String icon) {
    this.icon = icon;
  }

  public Integer getOrderNum() {
    return orderNum;
  }

  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }

  public String getIsSystemMenu() {
    return isSystemMenu;
  }

  public void setIsSystemMenu(String isSystemMenu) {
    this.isSystemMenu = isSystemMenu;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }
}
