package com.devplatform.admin.modules.sys.bean;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

/**
 * 用户与角色对应关系
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:28:39
 */
@ApiModel(value = "用户与角色对应关系对象", description = "用户与角色对应关系")
@TableName("sys_user_role")
public class SysUserRoleEntity implements Serializable {

  private static final long serialVersionUID = -23248503639080660L;

  @ApiModelProperty("主键id")
  @TableId
  private String id;

  @ApiModelProperty("用户id")
  private String userId;

  @ApiModelProperty("角色id")
  private String roleId;

  @ApiModelProperty("系统标识")
  private String sysSign;

  @ApiModelProperty("是否已删除(0未删除，1已删除)")
  private Integer deleted;

  @ApiModelProperty("创建人")
  private String createUserId;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("修改人")
  private String updateUserId;

  @ApiModelProperty("修改时间")
  private Date updateTime;

  @ApiModelProperty("备用项1")
  private String byx1;

  @ApiModelProperty("备用项2")
  private String byx2;

  @ApiModelProperty("备用项3")
  private String byx3;

  private String stationId;

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  public Integer getDeleted() {
    return deleted;
  }

  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }

  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public String getByx1() {
    return byx1;
  }

  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }

  public String getByx2() {
    return byx2;
  }

  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }

  public String getByx3() {
    return byx3;
  }

  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }
}
