package com.devplatform.admin.modules.sys.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.sys.bean.SysOss;
import com.devplatform.admin.modules.sys.service.SysOssService;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"附件信息表接口"})
@RestController
@RequestMapping("/sysOss")
public class SysOssController extends AbstractController {

  @Autowired private SysOssService sysOssService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取附件信息表分页数据列表", notes = "根据条件获取附件信息表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = sysOssService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 附件信息表对象
   * @return
   */
  @ApiOperation(value = "新增附件信息表数据", notes = "新增附件信息表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "附件信息表实体对象", required = true) SysOss bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateDate(new Date());
    sysOssService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 附件信息表对象
   * @return
   */
  @ApiOperation(value = "修改附件信息表数据", notes = "修改附件信息表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "附件信息表实体对象", required = true) SysOss bean) {
    ValidatorUtils.validateEntity(bean);
    sysOssService.update(
        bean,
        new QueryWrapper<SysOss>().like(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取附件信息表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取附件信息表对象", notes = "根据ID获取附件信息表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    SysOss bean = sysOssService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取附件信息表对象
   *
   * @param ids 附件信息表对象主键数组
   * @return
   */
  @ApiOperation(value = "根据ID批量删除附件信息表数据", notes = "根据ID批量删除附件信息表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    sysOssService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }
}
