package com.devplatform.admin.modules.sys.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.sys.model.SysCommandLogModel;
import com.devplatform.admin.modules.sys.bean.SysCommandLog;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SysCommandLog Mapper
 * 用于指令日志表的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SysCommandLogDao extends MyBaseMapper<SysCommandLog> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SysCommandLogModel model);

    /**
     * 查询指令日志表分页数据
     * @param model
     * @return
     */
    List<SysCommandLog> queryPageList(SysCommandLogModel model);

    Map<String, Object> getBeanById(String id);
}
