package com.devplatform.admin.modules.sys.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.sys.model.SysFaulalarmModel;
import com.devplatform.admin.modules.sys.bean.SysFaulalarm;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * SysFaulalarm Mapper
 * 用于设备故障报警表的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SysFaulalarmDao extends MyBaseMapper<SysFaulalarm> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SysFaulalarmModel model);

    /**
     * 查询设备故障报警表分页数据
     * @param model
     * @return
     */
    List<SysFaulalarm> queryPageList(SysFaulalarmModel model);

    /**
     * 按资源点类型分组统计数量
     * @param params
     * @return
     */
    List<Map<String, Object>> getListGroupByResourceType(@Param("params")Map<String, Object> params);

    /**
     * 按资源点id分组统计数量
     * @param params
     * @return
     */
    List<Map<String, Object>> getListGroupByResourceId(@Param("params")Map<String, Object> params);

    List<Map<String, Object>> getCountByResourceType(@Param("resourceType")String resourceType,@Param("startTime")String startTime,@Param("endTime")String endTime);
}
