package com.devplatform.admin.modules.sys.dao;

import com.devplatform.admin.modules.sys.bean.SysMenuEntity;
import com.devplatform.common.dao.MyBaseMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 菜单管理
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:33:01
 */
@Mapper
public interface SysMenuDao extends MyBaseMapper<SysMenuEntity> {

  /**
   * 根据父菜单，查询子菜单
   * @param parentId
   * @return
   */
  List<SysMenuEntity> queryListParentId(String parentId);

  /**
   * 获取不包含按钮的菜单列表
   * @return
   */
  List<SysMenuEntity> queryNotButtonList();

  /**
   * 修改角色菜单
   * @param roleId
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getRoleMenu(
      @Param("roleId") String roleId, @Param("stationId") String stationId);

  /**
   * 获取用户所有菜单权限
   * @param userId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getAllMenuListByUserId(
      @Param("userId") String userId, @Param("stationId") String stationId);

  /**
   * 获取用户所有菜单权限
   * @param userId
   * @return
   */
  List<Map<String, Object>> getAllMenuListByUserId1(@Param("userId") String userId);

  /**
   * 获取用户导航菜单
   * @param userId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getNav(
      @Param("userId") String userId, @Param("stationId") String stationId);
}
