package com.devplatform.admin.modules.sys.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.sys.model.SysResourceRunningTimeTjModel;
import com.devplatform.admin.modules.sys.bean.SysResourceRunningTimeTj;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SysResourceRunningTimeTj Mapper
 * 用于设备运行时间统计表的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SysResourceRunningTimeTjDao extends MyBaseMapper<SysResourceRunningTimeTj> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SysResourceRunningTimeTjModel model);

    /**
     * 查询设备运行时间统计表分页数据
     * @param model
     * @return
     */
    List<SysResourceRunningTimeTj> queryPageList(SysResourceRunningTimeTjModel model);

    Map<String, Object> totalDay(String time);

    Map<String, Object> totalMonth(String time);
}
