package com.devplatform.admin.modules.sys.dao;

import com.devplatform.admin.modules.sys.bean.SysRoleEntity;
import com.devplatform.common.dao.MyBaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;

/**
 * 角色管理
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:33:33
 */
@Mapper
public interface SysRoleDao extends MyBaseMapper<SysRoleEntity> {

  /**
   * 查询用户创建的角色ID列表
   * @param createUserId
   * @return
   */
  List<String> queryRoleIdList(String createUserId);

  /**
   * 查询用户选择的角色列表
   *
   * @param userId
   * @return
   */
  public List<SysRoleEntity> queryUserRoleList(String userId);

  /**
   * 批量解除用户角色关系
   * @param userId
   */
  public void deleteUserRole(String userId);
}
