package com.devplatform.admin.modules.sys.model;

import com.devplatform.admin.common.model.BaseModel;
import com.devplatform.admin.modules.sys.bean.SysRoleEntity;
import java.util.Date;
import java.util.List;

/**
 * 主办方信息表的Model
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:28:55
 */
public class SysUserModel extends BaseModel {

  /** */
  private static final long serialVersionUID = 3559046249781460649L;

  /** 用户ID */
  private String userId;

  /** 用户名 */
  private String username;

  /** 密码 */
  private String password;

  /** 盐 */
  private String salt;

  /** 邮箱 */
  private String email;

  /** 手机号 */
  private String mobile;

  /** 状态 0：禁用 1：正常 */
  private Integer status;

  /** 角色ID列表 */
  private List<String> roleIdList;

  private List<SysRoleEntity> userRoleList;

  private String stationId;
  /** 创建者ID */
  private String createUserId;
  /** 创建时间 */
  private Date createTime;
  /** 部门 */
  private String orgId;
  /** 创建时间 */
  private String detail;
  private String orgName;
  private String roleName;
  private Integer dataAuthority;

  public List<SysRoleEntity> getUserRoleList() {
    return userRoleList;
  }

  public void setUserRoleList(List<SysRoleEntity> userRoleList) {
    this.userRoleList = userRoleList;
  }

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public Integer getDataAuthority() {
    return dataAuthority;
  }

  public void setDataAuthority(Integer dataAuthority) {
    this.dataAuthority = dataAuthority;
  }

  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public String getOrgId() {
    return orgId;
  }

  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  public String getDetail() {
    return detail;
  }

  public void setDetail(String detail) {
    this.detail = detail;
  }

  /**
   * 获取：
   *
   * @return String
   */
  public String getUserId() {
    return userId;
  }

  /**
   * 设置：
   *
   * @param userId
   */
  public void setUserId(String userId) {
    this.userId = userId;
  }

  /**
   * 获取：用户名
   *
   * @return String
   */
  public String getUsername() {
    return username;
  }

  /**
   * 设置：用户名
   *
   * @param username 用户名
   */
  public void setUsername(String username) {
    this.username = username;
  }

  /**
   * 获取：密码
   *
   * @return String
   */
  public String getPassword() {
    return password;
  }

  /**
   * 设置：密码
   *
   * @param password 密码
   */
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * 获取：邮箱
   *
   * @return String
   */
  public String getEmail() {
    return email;
  }

  /**
   * 设置：邮箱
   *
   * @param email 邮箱
   */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * 获取：手机号
   *
   * @return String
   */
  public String getMobile() {
    return mobile;
  }

  /**
   * 设置：手机号
   *
   * @param mobile 手机号
   */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * 获取：状态 0：禁用 1：正常
   *
   * @return Integer
   */
  public Integer getStatus() {
    return status;
  }

  /**
   * 设置：状态 0：禁用 1：正常
   *
   * @param status 状态 0：禁用 1：正常
   */
  public void setStatus(Integer status) {
    this.status = status;
  }

  /**
   * 获取：创建时间
   *
   * @return Date
   */
  public Date getCreateTime() {
    return createTime;
  }

  /**
   * 设置：创建时间
   *
   * @param createTime 创建时间
   */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public List<String> getRoleIdList() {
    return roleIdList;
  }

  public void setRoleIdList(List<String> roleIdList) {
    this.roleIdList = roleIdList;
  }

  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  public String getSalt() {
    return salt;
  }

  public void setSalt(String salt) {
    this.salt = salt;
  }
}
