package com.devplatform.admin.modules.sys.redis;

import com.devplatform.admin.common.utils.RedisKeys;
import com.devplatform.admin.common.utils.RedisUtils;
import com.devplatform.admin.modules.sys.bean.SysConfigEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 系统配置Redis
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017/7/18 21:08
 */
@Component
public class SysConfigRedis {
  @Autowired private RedisUtils redisUtils;

  public void saveOrUpdate(SysConfigEntity config) {
    if (config == null) {
      return;
    }
    String key = RedisKeys.getSysConfigKey(config.getParamKey());
    redisUtils.set(key, config);
  }

  public void delete(String configKey) {
    String key = RedisKeys.getSysConfigKey(configKey);
    redisUtils.delete(key);
  }

  public SysConfigEntity get(String configKey) {
    String key = RedisKeys.getSysConfigKey(configKey);
    return redisUtils.get(key, SysConfigEntity.class);
  }
}
