package com.devplatform.admin.modules.sys.service;

import com.devplatform.admin.modules.sys.bean.SysConfigEntity;
import com.devplatform.common.service.MyBaseService;

/**
 * 系统配置信息
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年12月4日 下午6:49:01
 */
public interface SysConfigService extends MyBaseService<SysConfigEntity> {

  /**
   * 保存配置信息
   * @param config
   * @return
   */
  @Override
  public boolean save(SysConfigEntity config);

  /**
   * 更新配置信息
   * @param config
   */
  public void update(SysConfigEntity config);

  /**
   * 根据key，更新value
   * @param key
   * @param value
   */
  public void updateValueByKey(String key, String value);

  /**
   * 删除配置信息
   * @param ids
   */
  public void deleteBatch(String[] ids);

  /**
   * 根据key，获取配置的value值
   * @param key
   * @return
   */
  public String getValue(String key);

  /**
   * 根据key，获取value的Object对象
   * @param key
   * @param clazz
   * @param <T>
   * @return
   */
  public <T> T getConfigObject(String key, Class<T> clazz);
}
