package com.devplatform.admin.modules.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.sys.bean.SysLogEntity;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.model.SysLogModel;
import com.devplatform.common.service.MyBaseService;
import org.apache.ibatis.annotations.Param;

/**
 * 系统日志
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-03-08 10:40:56
 */
public interface SysLogService extends MyBaseService<SysLogEntity> {
  /**
   * 查询日志列表
   * @param page
   * @param model
   * @return
   */
  Page<SysLogEntity> queryPageList(
      @Param("page") Page<SysLogEntity> page, @Param("model") SysLogModel model);

  /**
   * 保存站点子系统操作日志
   * @param operation
   * @param blockName
   * @param detail
   * @param method
   * @param param
   * @param user
   * @param startTime
   * @param sysSign
   * @param stationId
   */
  void saveLogRoutesSub(
      String operation,
      String blockName,
      String detail,
      String method,
      Object param,
      SysUserEntity user,
      Long startTime,
      String sysSign,
      String stationId);
}
