package com.devplatform.admin.modules.sys.service;

import com.devplatform.admin.modules.sys.bean.SysRoleMenuEntity;
import com.devplatform.common.service.MyBaseService;
import java.util.ArrayList;
import java.util.List;

/**
 * 角色与菜单对应关系
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:42:30
 */
public interface SysRoleMenuService extends MyBaseService<SysRoleMenuEntity> {

  /**
   * 保存角色菜单权限
   * @param sysSign
   * @param roleId
   * @param menuIdList
   */
  void saveOrUpdate(String sysSign, String roleId, List<String> menuIdList);

  /**
   * 根据角色ID，获取菜单ID列表
   * @param roleId
   * @param stationId
   * @return
   */
  List<String> queryMenuIdList(String roleId, String stationId);

  /**
   * 根据角色ID数组，批量删除
   * @param roleIds
   * @return
   */
  int deleteBatch(String[] roleIds);

  /**
   * 修改角色菜单权限
   * @param sysSign
   * @param roleId
   * @param menuIds
   * @param stationId
   */
  void updateRoleMenu(String sysSign, String roleId, ArrayList<String> menuIds, String stationId);
}
