package com.devplatform.admin.modules.sys.service;

import com.devplatform.admin.modules.sys.bean.SysRoleEntity;
import com.devplatform.common.service.MyBaseService;
import java.util.List;

/**
 * 角色
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:42:52
 */
public interface SysRoleService extends MyBaseService<SysRoleEntity> {

  /**
   * 保存用户
   * @param role
   * @return
   */
  boolean saveMenu(SysRoleEntity role);

  /**
   * 修改角色
   * @param role
   */
  void update(SysRoleEntity role);

  /**
   * 批量删除角色
   * @param roleIds
   * @param sysSign
   */
  void deleteBatch(String[] roleIds, String sysSign);

  /**
   * 查询用户创建的角色ID列表
   * @param createUserId
   * @return
   */
  List<String> queryRoleIdList(String createUserId);

  /**
   * 查询用户选择的角色列表
   * @param userId
   * @return
   */
  List<SysRoleEntity> queryUserRoleList(String userId);

  /**
   * 添加角色
   * @param sysSign
   * @param userId
   * @param roleIds
   * @param stationId
   */
  void addRole(String sysSign, String userId, String roleIds, String stationId);

  /**
   * 修改角色
   * @param role
   */
  void updateRole(SysRoleEntity role);
}
