package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.common.utils.DateUtils;
import com.devplatform.admin.modules.sys.bean.SysCaptchaEntity;
import com.devplatform.admin.modules.sys.dao.SysCaptchaDao;
import com.devplatform.admin.modules.sys.service.SysCaptchaService;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 验证码
 *
 * @author Mark sunlightcs@gmail.com
 * @since 2.0.0 2018-02-10
 */
@Service("sysCaptchaService")
public class SysCaptchaServiceImpl extends MyBaseServiceImpl<SysCaptchaDao, SysCaptchaEntity>
    implements SysCaptchaService {
  @Autowired private Producer producer;

  @Override
  public BufferedImage getCaptcha(String uuid) {
    if (StringUtils.isBlank(uuid)) {
      throw new RRException("uuid不能为空");
    }
    // 生成文字验证码
    String code = producer.createText();

    SysCaptchaEntity captchaEntity = new SysCaptchaEntity();
    captchaEntity.setUuid(uuid);
    captchaEntity.setCode(code);
    // 5分钟后过期
    captchaEntity.setExpireTime(DateUtils.addDateMinutes(new Date(), 4));
    this.save(captchaEntity);

    return producer.createImage(code);
  }

  @Override
  public boolean validate(String uuid, String code) {
    SysCaptchaEntity captchaEntity = this.getById(uuid);
    if (captchaEntity == null) {
      return false;
    }

    // 删除验证码
    this.removeById(uuid);

    if (captchaEntity.getCode().equalsIgnoreCase(code)
        && captchaEntity.getExpireTime().getTime() >= System.currentTimeMillis()) {
      return true;
    }

    return false;
  }
}
